<?php

namespace Wi\Admin\CoreBundle\Templating\Helper;

use Symfony\Component\Templating\Helper\Helper;
use Wi\Admin\CoreBundle\Service\Seo;

/**
 * Seo helper.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SeoHelper extends Helper
{
    /**
     * @var Seo
     */
    private $seo;

    /**
     * Constructor.
     *
     * @param Seo $seo
     */
    public function __construct(Seo $seo)
    {
        $this->seo = $seo;
    }

    // -------------------------------------------------------------------------

    /**
     * Pobiera wyrenderowane metadane.
     *
     * @param object $obj
     * @return string
     */
    public function getMeta($obj = null)
    {
        return $this->seo->getMeta($obj);
    }

    /**
     * Pobiera tablicę metadanych.
     *
     * @param object $obj
     * @return array
     */
    public function getMetaArray($obj = null)
    {
        return $this->seo->getMetaArray($obj);
    }

    /**
     * Pobiera tablicę danych OpenGraph.
     *
     * @param object $obj
     * @return array
     */
    public function getOgArray($obj = null)
    {
        return $this->seo->getOgArray($obj);
    }

    // ------------------------------------------------------------
    // Inherit functions.
    // ------------------------------------------------------------

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'seo';
    }
}
