<?php

namespace Wi\Admin\CoreBundle\Twig\Extension;

use Wi\Admin\CoreBundle\Service\Config;

/**
 * Config extension for twig.
 *
 * @author      Jakub Nowak <mr9nowak@gmail.com>
 * @copyright   2017 Jakub Nowak
 * @link        http://www.jakubnowak.com.pl/
 * @version     1.0.0
 */
class ConfigExtension extends \Twig_Extension implements \Twig_Extension_GlobalsInterface
{
    /**
     * @var Config
     */
    private $config;

    /**
     * Constructor.
     *
     * @param Config $config
     */
    public function __construct(Config $config)
    {
        $this->config = $config;
    }

    // -------------------------------------------------------------------------

    /**
     * Czy komentarze WiCMS są włączone?
     *
     * @return bool
     */
    public function isWicmsCommentsEnabled()
    {
        return $this->config->isWicmsCommentsEnabled();
    }

    /**
     * Czy komentarze DISQUS są włączone?
     *
     * @return bool
     */
    public function isDisqusCommentsEnabled()
    {
        return $this->config->isDisqusCommentsEnabled();
    }

    /**
     * Czy komentarze FACEBOOK są włączone?
     *
     * @return bool
     */
    public function isFacebookCommentsEnabled()
    {
        return $this->config->isFacebookCommentsEnabled();
    }

    // -------------------------------------------------------------------------

    /**
     * Get globals.
     *
     * @return array
     */
    public function getGlobals()
    {
        $globals = [];

        foreach ($this->config->getConfig() as $key => $value) {
            $this->assignArrayByPath($globals, $key, $value);
        }

        return $globals;
    }

    /**
     * {@inheritdoc}
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction('isWicmsCommentsEnabled', [$this, 'isWicmsCommentsEnabled']),
            new \Twig_SimpleFunction('isDisqusCommentsEnabled', [$this, 'isDisqusCommentsEnabled']),
            new \Twig_SimpleFunction('isFacebookCommentsEnabled', [$this, 'isFacebookCommentsEnabled']),
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'app_config';
    }

    // -------------------------------------------------------------------------

    /**
     * Assign array by path.
     *
     * @param array &$arr
     * @param string $path
     * @param string $value
     * @param string $separator Default is a dot '.'.
     */
    private function assignArrayByPath(&$arr, $path, $value, $separator = '.')
    {
        $keys = explode($separator, $path);

        foreach ($keys as $key) {
            $arr = &$arr[$key];
        }

        $arr = $value;
    }
}
