<?php

namespace Wi\Admin\CoreBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Klasa do obsługi wysyłania maili z aplikacji.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @deprecated Zmiana na rzecz Wi\Admin\CoreBundle\Service\Mailer
 */
class Email
{
    /**
     * Container Interface object.
     *
     * @var ContainerInterface
     */
    protected $container;

    /**
     * Swift Mailer.
     *
     * @var Swift_Mailer
     */
    protected $mailer;

    /**
     * Templating Engine.
     *
     * @var DelegatingEngine
     */
    protected $templating;

    // ------------------------------------------------------------
    // Messages Variables.
    // ------------------------------------------------------------

    /**
     * Body message.
     *
     * @var string
     */
    protected $body;

    /**
     * Email from.
     *
     * @var string|array
     */
    protected $from;

    /**
     * Swift Message.
     *
     * @var Swift_Message
     */
    protected $message;

    /**
     * Subject.
     *
     * @var string
     */
    protected $subject;

    /**
     * Email to.
     *
     * @var string|array
     */
    protected $to;

    /**
     * Construct.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // Set Container Interface variable.
        $this->container = $container;

        // Set Templating Engine.
        $this->templating = $container->get('templating');

        // Set Mailer.
        $this->mailer = $container->get('mailer');

        // Set email from.
        $this->setFrom($this->container->getParameter('mailer_user'));
    }

    /**
     * Create message.
     *
     * @return  \Swift_Message
     */
    public function createMessage()
    {
        return \Swift_Message::newInstance()
            ->setSubject($this->subject)
            ->setFrom($this->from)
            ->setTo($this->to)
            ->setBody($this->body, 'text/html')
        ;
    }

    /**
     * Render view.
     *
     * @param   string  $view
     * @param   array   $params
     * @return  \Symfony\Component\HttpFoundation\Response
     */
    public function render($view, $params = [])
    {
        return $this->templating->render($view, array_merge($params, [
            'subject' => $this->subject,
            'message' => $this->message,
        ]));
    }

    /**
     * Set from.
     *
     * $from example:
     * String e.g. send@domain.com
     * Array e.g. ['send@domain.com' => 'John Doe']
     *
     * @param   string|array $from
     * @return  Email
     */
    public function setFrom($from)
    {
        $this->from = $from;

        return $this;
    }

    /**
     * Set message.
     *
     * @param   string $message Default is null.
     * @return  Email
     */
    public function setMessage($message = null)
    {
        $this->message = $message;

        if (is_null($message)) {
            $this->message = $this->createMessage();
        }

        return $this;
    }

    /**
     * Set subject.
     *
     * @param   string $subject
     * @return  Email
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * Set to.
     *
     * $to example:
     * String e.g. recipient@domain.com
     * Array e.g. ['recipient1@domain.com', 'recipient2@domain.com']
     *
     * @param   string|array $to
     * @return  Email
     */
    public function setTo($to)
    {
        $this->to = $to;

        return $this;
    }

    /**
     * Set view.
     *
     * @param   string  $view
     * @param   array   $params
     * @return  Email
     */
    public function setView($view, $params = [])
    {
        $this->body = $this->render($view, $params);

        return $this;
    }

    /**
     * Send message.
     *
     * @return bool
     */
    public function send()
    {
        return $this->mailer->send($this->message);
    }
}
