<?php

namespace Wi\Admin\DownloadBundle\Form;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\DownloadBundle\Entity\Category;
use Wi\Admin\DownloadBundle\Entity\File;

class FileType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('size', HiddenType::class, [
                'error_bubbling' => false,
            ])
            ->add('systemName', HiddenType::class, [
                'error_bubbling' => false,
            ])
            ->add('title', TextType::class, [
                'attr' => [
                    'class' => '',
                ],
                'required' => true,
            ])
            ->add('content', TextareaType::class, [
                'attr' => [
                    'class' => 'tinyMCE',
                ],
                'required' => false,
            ])
            ->add('categories', EntityType::class, [
                'attr' => [
                    'class' => 'select2',
                ],
                'placeholder' => 'file.form.select.placeholder',
                'class' => Category::class,
                'choice_label' => 'name',
                'required' => false,
                'multiple' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => File::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_downloadbundle_file';
    }
}
