<?php

namespace Wi\Admin\DownloadBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Wi\Admin\DownloadBundle\Entity\File;

/**
 * FileRepository
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class FileRepository extends EntityRepository
{
    /**
     * Pobiera zapytanie dla paginacji.
     *
     * @param int $category_id
     * @param string $search
     * @return Query
     */
    public function getFindAllActiveQuery($category_id = null, $search = '')
    {
        $qb = $this->createQueryBuilder('f')
            ->addSelect('c')
            ->leftJoin('f.categories', 'c')
            ->where('f.status = :status')
        ;

        $params = [
            'status' => File::STATUS_ACTIVE,
        ];

        if ($category_id) {
            $qb->andWhere('c.id = :category_id');
            $params['category_id'] = (int) $category_id;
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
        ;
    }
}
