<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_download_file_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.file.categories.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.list'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.categories.list'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_category_show', ['id' => $category->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.categories.show'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-folder-2"></i><?php echo $view['translator']->trans('file.categories.list.title'); ?> - <?php echo $view['translator']->trans('file.categories.show.subtitle'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('file.categories.show.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-folder-2"></i><span><?php echo $view['translator']->trans('file.categories.show.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('file.categories.list.table.name'); ?>:</strong> <?php echo $category->getName(); ?></p>
            </div>
            <div class="row">
                <div class="large-2 columns"></div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_download_file_category_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/download.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
