<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_download_file_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.file.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.list'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_download_file_edit', ['id' => $file->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.edit'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<i class="icon-docs"></i><?php echo $view['translator']->trans('file.list.title'); ?> - <?php echo $view['translator']->trans('file.edit.subtitle'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('file.edit.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-doc"></i><span><?php echo $view['translator']->trans('file.edit.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.title.title'); ?></strong></p>
                <p><?php echo $view['translator']->trans('file.form.title.desc'); ?></p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                        <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['title'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['title'])); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.content.title'); ?></strong></p>
                <p><?php echo $view['translator']->trans('file.form.content.desc'); ?></p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                <?php echo ($view['form']->errors($form['content']) ? $view['form']->widget($form['content'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['content'])); ?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.categories.title'); ?></strong></p>
                <p><?php echo $view['translator']->trans('file.form.categories.desc'); ?></p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['categories']); ?></div>
                <?php echo ($view['form']->errors($form['categories']) ? $view['form']->widget($form['categories'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['categories'])); ?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <div class="news-add-form">
                    <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                        <i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?>
                    </button>

                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/download.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
