<?php

namespace Wi\Admin\FAQBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\FAQBundle\Entity\Question;

/**
 * Question Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class QuestionListener
{
    /**
     * Metoda jest wykonywana przed usunięciem pytania.
     *
     * @param  Question             $question
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(Question $question, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $question->setStatus('D');

        // Zapis.
        $em->persist($question);
        $em->flush();
    }
}
