<?php

namespace Wi\Admin\FAQBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * QuestionRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class QuestionRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie aktywne pytania.
     *
     * @return array
     */
    public function findAllActive()
    {
        return $this->createQueryBuilder('q')
            ->where('q.status = :status')
            ->andWhere('q.dateDeleted IS NULL')
            ->setParameters([
                'status' => 'A',
            ])
            ->orderBy('q.orderNr', 'ASC')
            ->addOrderBy('q.question', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobiera zapytanie dla wszystkich aktywnych aktualności.
     *
     * @param int $category_id ID kategorii do filtrowania aktualności.
     * @param string $search
     * @return array
     */
    public function getFindAllActiveQuery($category_id = null, $search = '')
    {
        // Utworzenie QueryBuilder'a.
        $qb =  $this->createQueryBuilder('q')
            ->leftJoin('q.categories', 'c')
            ->where('q.status = :status')
            ->andWhere('q.dateDeleted IS NULL')
            ->orderBy('q.orderNr', 'ASC')
            ->addOrderBy('c.name', 'ASC')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        // Jeśli ID kategorii zostało przekazane to zawęźić do tej kategorii.
        if ($category_id) {
            $params['category_id'] = $category_id;
            $qb->andWhere('c.id = :category_id');
        }

        // Jeśli tekst do wyszukania jest przekazany to szukaj.
        if ($search) {
            $params['search'] = '%' . $search . '%';
            $qb->andWhere($qb->expr()->orX(
                $qb->expr()->like('q.question', ':search'),
                $qb->expr()->like('q.shortcut', ':search'),
                $qb->expr()->like('q.answer', ':search'),
                $qb->expr()->like('q.metaTitle', ':search'),
                $qb->expr()->like('q.metaDescription', ':search'),
                $qb->expr()->like('q.metaCanonical', ':search')
            ));
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
            ->getResult()
        ;
    }
}
