<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_category_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.category.catEdit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_category_index'); ?>">
            <?php echo $view['translator']->trans('breadcrumbs.category.catList'); ?>
        </a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_category_edit', array('id' => $category->getId())); ?>">
            <?php echo $view['translator']->trans('breadcrumbs.category.catEdit'); ?>
        </a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-help-circled"></i>
    <?php echo $view['translator']->trans('faqQuestion.listTitle'); ?> - <?php echo $view['translator']->trans('catEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('catEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-edit"></i>
            <span><?php echo $view['translator']->trans('catEdit.listSubTitle'); ?> - <?php echo $category->getName();?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('catEdit.formTitle'); ?></strong></p>
                <p><?php echo $view['translator']->trans('catEdit.formDesc'); ?></p>
            </div>
            <div class="large-10 columns">
                <?php if ($view['form']->errors($edit_form)): ?>
                    <div class="alert callout small">
                        <?php echo $view['form']->errors($edit_form); ?>
                    </div>
                <?php endif; ?>
                <?php echo $view['form']->start($edit_form) ?>
                <div class="row">
                    <div class="medium-12 large-6 columns end">
                        <?php echo $view['form']->label($edit_form['name']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['name']) ?>
                            </div>
                        <?php echo($view['form']->errors($edit_form['name']) ? $view['form']->widget($edit_form['name'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['name'])) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="small-6 medium-4 large-2 columns end">
                        <?php echo $view['form']->label($edit_form['orderNr']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['orderNr']) ?>
                            </div>
                        <?php echo($view['form']->errors($edit_form['orderNr']) ? $view['form']->widget($edit_form['orderNr'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['orderNr'])) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="medium-12 large-6 columns end">
                        <?php echo $view['form']->label($edit_form['description']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['description']) ?>
                            </div>
                        <?php echo($view['form']->errors($edit_form['description']) ? $view['form']->widget($edit_form['description'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['description'])) ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
            </div>
            <div class="large-10 columns">
                <div class="wi-konatkt-form">
                    <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                        <i class="icon-edit"></i>
                        <?php echo $view['translator']->trans('Form.send'); ?>
                    </button>
                    <?php echo $view['form']->end($edit_form) ?>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_faq_category_show', array('id' => $category->getId())); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
