<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>


<?php $view['slots']->set('title', $view['translator']->trans('title.faqQuestion.questionShow')) ?>


<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.questionShow'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-help-circled"></i><?php echo $view['translator']->trans('faqQuestion.listSubTitle'); ?> - <?php echo $view['translator']->trans('faqQuestionShow.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('faqQuestionShow.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowNews-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_faq_question_edit', array('id' => $question->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_faq_question_delete', ['id' => $question->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('faqQuestionShow.deleteButton'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <span><?php echo $view['translator']->trans('show.details'); ?> - <?php echo $question->getQuestion(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row showQuestion">
                <div class="large-10 columns">
                    <div class="showShortDesc">
                        <p><strong><?php echo $view['translator']->trans('faqQuestionNew.form.titleTitle'); ?>:</strong>
                        <?php echo $question->getQuestion(); ?></p>
                        <p><strong><?php echo $view['translator']->trans('faqQuestionNew.form.shortTitle'); ?>:</strong>
                        <?php echo $question->getShortcut(); ?></p>
                    </div>
                    <p><strong><?php echo $view['translator']->trans('faqQuestionNew.form.dateTitle'); ?>:</strong>
                        <?php if ($question->getDateOfPublication()): ?>
                            <?php echo $question->getDateOfPublication()->format('Y-m-d H:i:s'); ?>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionNew.form.catTitle'); ?>:</strong></p>
                </div>
                <div class="large-10 columns showCategoryQuestion">
                    <div class="tiny button-group">
                        <?php foreach ($question->getCategories() as $categories): ?>
                            <span class="info label secondary showQuestionButton"><?php echo $categories->getName(); ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('faqQuestionNew.form.textTitle'); ?>:</strong></p>
                </div>
                <div class="large-10 columns">
                    <div class="callout"><?php echo $question->getAnswer(); ?></div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                        <p><strong><?php echo $view['translator']->trans('faqQuestionShow.edit'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('faqQuestionShow.editDesc'); ?></p>
                    <?php endif; ?>
                </div>
                <div class="large-10 columns">
                    <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_faq_question_edit', array('id' => $question->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowPagesSEO-dropdown">
                        <i class="icon-cog-5"></i>
                    </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowPagesSEO-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_faq_question_edit', array('id' => $question->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-chart-bar-2"></i>
                <span>
                    <?php echo $view['translator']->trans('pagesShow.seosem'); ?>
                </span>
            </h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns"></div>
                <div class="large-10 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaTitle'); ?>:</strong>
                        <?php echo $view['front']->getMetaTitle($question); ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaDescription'); ?>:</strong>
                        <?php echo $view['front']->getMetaDescription($question); ?>
                    </p>
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.titleMetaCanonical'); ?>:</strong>
                        <?php echo $view['front']->getMetaCanonical($question); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
