<?php

namespace Wi\Admin\LinkBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\LinkBundle\Entity\Link;
use Wi\Admin\LinkBundle\Form\LinkType;
use Wi\Admin\LinkBundle\Form\LinkEditType;

/**
 * Link controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LinkController extends Controller
{
    /**
     * Lista skróconych linków oraz formularz dodawania nowych.
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $link = new Link();

        $form = $this->createForm(LinkType::class, $link);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em->persist($link);
            $em->flush($link);

            return $this->redirectToRoute('wi_admin_link_index');
        }

        $formEdit = $this->createForm(LinkEditType::class);
        $formEdit->handleRequest($request);

        if ($formEdit->isSubmitted() && $formEdit->isValid()) {
            $linkEdit = $em->getRepository('WiAdminLinkBundle:Link')->find($formEdit->get('id')->getData());
            $linkEdit->setUtmEnable($formEdit->get('utmEnable')->getData());
            $linkEdit->setUtmSource($formEdit->get('utmSource')->getData());
            $linkEdit->setUtmMedium($formEdit->get('utmMedium')->getData());
            $linkEdit->setUtmName($formEdit->get('utmName')->getData());
            $linkEdit->setUtmTerm($formEdit->get('utmTerm')->getData());
            $linkEdit->setUtmContent($formEdit->get('utmContent')->getData());
            $em->persist($linkEdit);
            $em->flush($linkEdit);

            return $this->redirectToRoute('wi_admin_link_index');
        }

        $links = $em->getRepository('WiAdminLinkBundle:Link')->findBy([], ['dateCreated' => 'DESC']);

        return $this->render('WiAdminLinkBundle:Link:index.html.php', [
            'form' => $form->createView(),
            'formEdit' => $formEdit->createView(),
            'links' => $links,
        ]);
    }

    public function changeStatusAction(Request $request, Link $link)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        switch ($request->attributes->get('_route')) {
            case 'wi_admin_link_change_status_disable_redirect':
                $link->setStatus(Link::STATUS_DISABLED_REDIRECT);
                $em->persist($link);
                break;
            case 'wi_admin_link_change_status_disable_not_found':
                $link->setStatus(Link::STATUS_DISABLED_NOT_FOUND);
                $em->persist($link);
                break;
            case 'wi_admin_link_change_status_delete':
                $em->remove($link);
                break;
        }

        $em->flush($link);

        return $this->redirectToRoute('wi_admin_link_index');
    }
}
