<?php

namespace Wi\Admin\LinkBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\LinkBundle\Entity\Link;

/**
 * Link Edit Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LinkEditType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('id', HiddenType::class)
            ->add('url', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field',
                    'placeholder' => 'link.form.url',
                    'readonly' => true,
                ],
                'label' => false,
                'required' => true,
                'translation_domain' => 'link',
            ])
            ->add('utmEnable', CheckboxType::class, [
                'attr' => [
                    'class' => 'switch-input edit',
                ],
                'required' => false,
            ])
            ->add('utmSource', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmSource',
                'required' => false,
                'translation_domain' => 'link',
                'translation_domain' => 'link',
            ])
            ->add('utmMedium', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmMedium',
                'required' => false,
                'translation_domain' => 'link',
            ])
            ->add('utmName', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmName',
                'required' => false,
                'translation_domain' => 'link',
            ])
            ->add('utmTerm', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmTerm',
                'required' => false,
                'translation_domain' => 'link',
            ])
            ->add('utmContent', TextType::class, [
                'attr' => [
                    'class' => 'input-group-field utm-preview',
                ],
                'label' => 'link.form.utmContent',
                'required' => false,
                'translation_domain' => 'link',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_linkbundle_link_edit';
    }
}
