<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_media_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.media.List')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/media.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_media_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.media.media'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<i class="icon-file-image"></i><?php echo $view['translator']->trans('mediaList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('mediaList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php
$folderBlockTable = ['Auction', 'Gallery', 'Goal', 'News', 'Blog', 'Banner', 'Commercial', 'User'];
?>
<?php $view['slots']->start('body') ?>
    <div class="box mediaBox">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-docs"></i>
                <span><?php echo $view['translator']->trans('mediaList.listSubTitle'); ?>  -  <?php echo $view['translator']->trans('mediaList.here'); ?>: <a class="stopPropagation" href="<?php echo $view['router']->path('wi_admin_media_index'); ?>"><?php echo $view['translator']->trans('mediaList.folderMain'); ?></a><span class="youAreHere">/<?php echo $view['request']->getParameter('directory') ?></span></span>
            </h3></div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php if ($currentDirectory != $view['config']->getParameter('assets_dir')): ?>
                <div class="combackFolder">
                    <a class="mediaPlik funkcjonalnosc" href="<?php echo $view['router']->path('wi_admin_media_index'); ?><?php echo $previousDirectory; ?>">
                            <i class="icon-left-bold-1"></i>
                            <?php echo $view['translator']->trans('mediaList.comeback'); ?>
                    </a>
                </div>
            <?php endif ?>
            <div class="folderTitle">
                <p>
                    <?php echo $view['translator']->trans('mediaList.folders'); ?>:
                </p>
                <?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                    <?php if(!in_array(strstr($view['request']->getParameter('directory'),'/', true),
                        $folderBlockTable)):  ?>
                        <a class="button tiny" data-open="addFolder">
                            <i class="icon-folder-add"></i>
                            <?php echo $view['translator']->trans('mediaList.addFolder'); ?>
                        </a>
                        <div class="tiny reveal" id="addFolder" data-reveal>
                            <?php echo $view['form']->start($addFolderForm, [
                                'attr' => [
                                    'class' => 'zmiennazwe',
                                ],
                            ]); ?>
                            <?php echo $view['form']->widget($addFolderForm['name']); ?>
                            <button type="submit" class="button float-right"><?php echo $view['translator']->trans('Form.create'); ?></button>
                            <?php echo $view['form']->end($addFolderForm); ?>
                            <button class="close-button" data-close aria-label="Close modal" type="button">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div class="folderGroup">
                <?php $j=0;?>
                <?php foreach ($directories as $directory): ?>
                    <?php $j++; ?>
                    <div class="mediaPlik folderPlik">
                        <div class="obiektMedia goToFolder" paramUrl="<?php echo $view['router']->path('wi_admin_media_index'); ?><?php echo $view['request']->getParameter('directory'); ?><?php echo $directory->getFilename(); ?>">
                            <i class="icon-folder-open-empty"></i>
                            <?php echo $directory->getFilename(); ?>
                        </div>
                        <?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                            <?php if((in_array(strstr($view['request']->getParameter('directory'),'/', true), $folderBlockTable) || in_array($directory->getFilename(), $folderBlockTable))): ?>

                            <?php else: ?>
                                <div class="opcje">
                                    <button type="button" class="float-right buttonOpcje" data-toggle="opcjePliku<?php echo $j; ?>"><i class="icon-cog-5"></i> </button>
                                    <div class="dropdown-pane bottom configBoxButtons" id="opcjePliku<?php echo $j; ?>" data-dropdown data-position="bottom" data-alignment="right" data-close-on-click="true">
                                        <ul class="no-bullet">
                                            <li>
                                                <a data-open="deleteFolder<?php echo $j; ?>">
                                                    <span>
                                                        <i class="icon-cancel-circled2"></i> <?php echo $view['translator']->trans('mediaList.delete'); ?>
                                                    </span>
                                                </a>
                                            </li>
                                            <li>
                                                <a data-open="zmiennazwe<?php echo $j; ?>">
                                                    <span>
                                                        <i class="icon-exchange-1"></i> <?php echo $view['translator']->trans('mediaList.changeName'); ?>
                                                    </span>
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="tiny reveal" id="deleteFolder<?php echo $j; ?>" data-reveal>
                                            <?php echo $view['form']->start($deleteForm); ?>
                                            <input type="hidden" name="<?php echo $deleteForm['delete']->vars['name']; ?>" id="<?php echo $deleteForm['delete']->vars['id'] . $j; ?>"
                                            <?php foreach ($deleteForm['delete']->vars['attr'] as $attr => $value): ?>
                                                <?php echo $attr; ?>="<?php echo $value; ?>"
                                            <?php endforeach ?>
                                            required
                                            value="<?php echo $directory->getFilename(); ?>",
                                            >
                                            <?php $deleteForm['delete']->setRendered(); ?>
                                            <div class="switch-admin">
                                                <p><?php echo $view['translator']->trans('mediaList.confirmTextFolder'); ?></p>
                                                <input type="checkbox" name="<?php echo $deleteForm['deleteConfirm']->vars['name']; ?>" id="<?php echo $deleteForm['deleteConfirm']->vars['id'] . $j; ?>"
                                                <?php foreach ($deleteForm['deleteConfirm']->vars['attr'] as $attr => $value): ?>
                                                    <?php echo $attr; ?>="<?php echo $value; ?>"
                                                <?php endforeach ?>
                                                required
                                                >
                                                <?php $deleteForm['deleteConfirm']->setRendered(); ?>
                                                <label class="switch-paddle" for="deleteConfirm<?php echo $j; ?>">
                                                    <span class="show-for-sr"><?php echo $view['translator']->trans('mediaList.confirmTextFolder'); ?></span>
                                                    <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                                    <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                                                </label>
                                                <button type="submit" class="button alert tiny float-right"><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('mediaList.confirmDelete'); ?></button>
                                            </div>
                                            <?php echo $view['form']->end($deleteForm); ?>
                                            <button class="close-button" data-close aria-label="Close modal" type="button">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="tiny reveal" id="zmiennazwe<?php echo $j; ?>" data-reveal>
                                            <?php echo $view['form']->start($renameForm, [
                                                'attr' => [
                                                    'class' => 'zmiennazwe',
                                                ],
                                            ]); ?>
                                            <input type="hidden" name="<?php echo $renameForm['oldName']->vars['name']; ?>" id="<?php echo $renameForm['oldName']->vars['id'] . $j; ?>"
                                            <?php foreach ($renameForm['oldName']->vars['attr'] as $attr => $value): ?>
                                                <?php echo $attr; ?>="<?php echo $value; ?>"
                                            <?php endforeach ?>
                                            required
                                            value="<?php echo str_replace('.' . preg_replace('/^.*\./', '', $directory->getFilename()), '', $directory->getFilename()) ?>",
                                            >
                                            <?php $renameForm['oldName']->setRendered(); ?>
                                            <input type="text" name="<?php echo $renameForm['name']->vars['name']; ?>" id="<?php echo $renameForm['name']->vars['id'] . $j; ?>"
                                            <?php foreach ($renameForm['name']->vars['attr'] as $attr => $value): ?>
                                                <?php echo $attr; ?>="<?php echo $value; ?>"
                                            <?php endforeach ?>
                                            required
                                            value="<?php echo str_replace('.' . preg_replace('/^.*\./', '', $directory->getFilename()), '', $directory->getFilename()) ?>",
                                            >
                                            <?php $renameForm['name']->setRendered(); ?>
                                            <button type="submit" class="button float-right"><?php echo $view['translator']->trans('Form.send'); ?></button>
                                            <?php echo $view['form']->end($renameForm); ?>
                                            <button class="close-button" data-close aria-label="Close modal" type="button">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach ?>
            </div>
            <div class="folderTitle">
                <p>
                    <?php echo $view['translator']->trans('mediaList.files'); ?>:
                </p>
            </div>
            <div class="filesGroup">
                <?php $i=$j+1; ?>
                <?php foreach ($files as $file): ?>
                    <?php $i++; ?>
                    <div class="mediaPlik plikPlik">
                        <div class="dataFile" data-nameFile="<?php echo $file->getFilename(); ?>"
                             data-typeFile="<?php echo $file->getExtension(); ?>"
                             data-urlFile="<?php echo $file->link; ?>"
                            <?php if($file->getExtension()=='jpg' || $file->getExtension()=='jpeg' || $file->getExtension()=='png'): ?>
                                data-dimensionFileW="<?php echo getimagesize($file)[0]; ?>px"
                                data-dimensionFileH="<?php echo getimagesize($file)[1]; ?>px"
                            <?php else: ?>
                                data-dimensionFileW=" "
                                data-dimensionFileH=" "
                            <?php endif; ?>
                             data-sizeFile="<?php echo $file->getSize(); ?>B"
                             data-i="<?php echo $i; ?>">
                        </div>
                        <div class="obiektMedia">
                            <?php if($file->getExtension()=='png'): ?>
                                <img src="<?php echo $file->link; ?>" style="<?php echo (getimagesize($file)[0]>getimagesize($file)[1] ? 'max-height: 100%' : 'max-width: 100%'); ?>">
                            <?php elseif ($file->getExtension()=='jpg'): ?>
                                <img src="<?php echo $file->link; ?>" style="<?php echo (getimagesize($file)[0]>getimagesize($file)[1] ? 'max-height: 100%' : 'max-width: 100%'); ?>">
                            <?php elseif ($file->getExtension()=='jepg'): ?>
                                <img src="<?php echo $file->link; ?>" style="<?php echo (getimagesize($file)[0]>getimagesize($file)[1] ? 'max-height: 100%' : 'max-width: 100%'); ?>">
                            <?php elseif ($file->getExtension()=='avi'): ?>
                                <i class="icon-file-video"></i>
                            <?php elseif ($file->getExtension()=='mp3'): ?>
                                <i class="icon-file-audio"></i>
                            <?php elseif ($file->getExtension()=='mp4'): ?>
                                <i class="icon-file-video"></i>
                            <?php elseif ($file->getExtension()=='pdf'): ?>
                                <i class="icon-file-pdf"></i>
                            <?php elseif ($file->getExtension()=='rar'): ?>
                                <i class="icon-file-archive"></i>
                            <?php elseif ($file->getExtension()=='zip'): ?>
                                <i class="icon-file-archive"></i>
                            <?php else: ?>
                                <i class="icon-doc"></i>
                            <?php endif; ?>
                        </div>
                        <div class="tytulPliku">
                            <?php echo $file->getFilename(); ?>
                        </div>
                        <div class="kreska"></div>
                        <div class="opcje">
                            <button type="button" class="float-right buttonOpcje" data-toggle="opcje<?php echo $i; ?>"><i class="icon-cog-5"></i> </button>
                            <div class="dropdown-pane bottom opcjePliku configBoxButtons" id="opcje<?php echo $i; ?>" data-dropdown data-position="bottom" data-alignment="right" data-close-on-click="true">
                                <ul class="no-bullet">
                                    <?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                                        <?php if(!in_array(strstr($view['request']->getParameter('directory'),'/', true),
                                            $folderBlockTable)):  ?>
                                            <li>
                                                <a data-open="deleteFile<?php echo $i; ?>">
                                                    <span>
                                                        <i class="icon-cancel-circled2"></i>
                                                        <?php echo $view['translator']->trans('mediaList.delete'); ?>
                                                    </span>
                                                </a>
                                            </li>
                                            <div class="tiny reveal" id="deleteFile<?php echo $i; ?>" data-reveal>
                                                <?php echo $view['form']->start($deleteForm); ?>
                                                <input type="hidden" name="<?php echo $deleteForm['delete']->vars['name']; ?>" id="<?php echo $deleteForm['delete']->vars['id'] . $i; ?>"
                                                <?php foreach ($deleteForm['delete']->vars['attr'] as $attr => $value): ?>
                                                    <?php echo $attr; ?>="<?php echo $value; ?>"
                                                <?php endforeach ?>
                                                required
                                                value="<?php echo $file->getFilename(); ?>",
                                                >
                                                <?php $deleteForm['delete']->setRendered(); ?>
                                                <div class="switch-admin">
                                                    <p><?php echo $view['translator']->trans('mediaList.confirmTextFile'); ?></p>
                                                    <input type="checkbox" name="<?php echo $deleteForm['deleteConfirm']->vars['name']; ?>" id="<?php echo $deleteForm['deleteConfirm']->vars['id'] . $i; ?>"
                                                    <?php foreach ($deleteForm['deleteConfirm']->vars['attr'] as $attr => $value): ?>
                                                        <?php echo $attr; ?>="<?php echo $value; ?>"
                                                    <?php endforeach ?>
                                                    required
                                                    >
                                                    <?php $deleteForm['deleteConfirm']->setRendered(); ?>
                                                    <label class="switch-paddle" for="deleteConfirm<?php echo $i; ?>">
                                                        <span class="show-for-sr"><?php echo $view['translator']->trans('mediaList.confirmTextFile'); ?></span>
                                                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                                                    </label>
                                                    <button type="submit" class="button alert tiny float-right"><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('mediaList.confirmDelete'); ?></button>
                                                </div>
                                                <?php echo $view['form']->end($deleteForm); ?>
                                                <button class="close-button" data-close aria-label="Close modal" type="button">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <li>
                                                <a data-open="zmien<?php echo $i; ?>">
                                                <span>
                                                    <i class="icon-exchange-1"></i>
                                                    <?php echo $view['translator']->trans('mediaList.changeName'); ?>
                                                </span>
                                                </a>
                                            </li>
                                            <div class="tiny reveal" id="zmien<?php echo $i; ?>" data-reveal>
                                                <?php echo $view['form']->start($renameForm, [
                                                    'attr' => [
                                                        'class' => 'zmiennazwe',
                                                    ],
                                                ]); ?>
                                                <input type="hidden" name="<?php echo $renameForm['oldName']->vars['name']; ?>" id="<?php echo $renameForm['oldName']->vars['id'] . $i; ?>"
                                                <?php foreach ($renameForm['oldName']->vars['attr'] as $attr => $value): ?>
                                                    <?php echo $attr; ?>="<?php echo $value; ?>"
                                                <?php endforeach ?>
                                                required
                                                value="<?php echo $file->getFilename(); ?>",
                                                >
                                                <?php $renameForm['oldName']->setRendered(); ?>
                                                <input type="text" name="<?php echo $renameForm['name']->vars['name']; ?>" id="<?php echo $renameForm['name']->vars['id'] . $i; ?>"
                                                <?php foreach ($renameForm['name']->vars['attr'] as $attr => $value): ?>
                                                    <?php echo $attr; ?>="<?php echo $value; ?>"
                                                <?php endforeach ?>
                                                required
                                                value="<?php echo str_replace('.' . preg_replace('/^.*\./', '', $file->getFilename()), '', $file->getFilename()) ?>",
                                                >
                                                <?php $renameForm['name']->setRendered(); ?>
                                                <button type="submit" class="button float-right"><?php echo $view['translator']->trans('Form.send'); ?></button>
                                                <?php echo $view['form']->end($renameForm); ?>
                                                <button class="close-button" data-close aria-label="Close modal" type="button">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <li>
                                        <a href="<?php echo $file->link; ?>" class="downloadFile" download="<?php echo $file->getFilename(); ?>">
                                            <span>
                                                <i class="icon-download"></i>
                                                <?php echo $view['translator']->trans('mediaList.download'); ?>
                                            </span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
                <?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                    <?php if(!in_array(strstr($view['request']->getParameter('directory'),'/', true),
                        $folderBlockTable)):  ?>
                        <div class="mediaPlik addPlik" id="dropdown">
                            <div id="drop-area" style="">
                                <b><span id="percent"></span></b>
                                <span class="block text-ellipsis" id="choosen-file"></span><br>
                            </div>
                        </div>
                        <hr>
                        <div class="row columns pojedynczyFormularz">
                            <p><?php echo $view['translator']->trans('mediaList.simpleForm'); ?></p>
                            <form action="<?php echo $view['router']->path('wi_admin_media_upload', ['d' => $view['request']->getParameter('directory'), 'ref' => 1]); ?>" enctype="multipart/form-data" method="post">
                                <input type="file" name="file" accept=".avi,.jpeg,.jpg,.mp3,.mp4,.pdf,.png,.rar,.zip">
                                <button type="submit" class="button"><i class="icon-upload"></i> <?php echo $view['translator']->trans('Form.send2'); ?></button>
                            </form>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            </div>
        </div>
    </div>
<div class="large reveal" id="modalInfoFile" data-reveal>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="box fileInfoBox">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configFileInfo-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="right" id="configFileInfo-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                            <?php if(!in_array(strstr($view['request']->getParameter('directory'),'/', true), $folderBlockTable)): ?>
                                <li>
                                    <a id="renameButton" class="" aria-haspopup="true" tabindex="0">
                                        <span>
                                            <i class="icon-exchange-1"></i>
                                            <?php echo $view['translator']->trans('mediaList.changeName'); ?>
                                        </span>
                                    </a>
                                </li>

                            <?php endif; ?>
                            <li>
                                <a id='downloadButton' download="download" href="" class=" ">
                                    <span>
                                        <i class="icon-download"></i>
                                        <?php echo $view['translator']->trans('mediaList.download'); ?>
                                    </span>
                                </a>
                            </li>
                            <?php if(!in_array(strstr($view['request']->getParameter('directory'),'/', true), $folderBlockTable)): ?>
                                <li>
                                    <a id="deleteButton" aria-haspopup="true" tabindex="0" class="">
                                        <span>
                                            <i class="icon-cancel-circled"></i>
                                            <?php echo $view['translator']->trans('mediaList.delete'); ?>
                                        </span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <i class="icon-docs"></i>
                <span><?php echo $view['translator']->trans('mediaList.listSubTitleInfo'); ?></span>
            </h3></div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block">
            <div class="row columns fileInfoBox1">
                <div id="imgFileInfo">
                    <img src="" id="fileImg">
                </div>
                <div class="fileInfoText">
                    <p class="fileInfoTitle">
                        <?php echo $view['translator']->trans('mediaList.fileName'); ?>:
                        <span id="fileName"></span>
                    </p>
                    <p class="fileInfoTitle">
                        <?php echo $view['translator']->trans('mediaList.fileSize'); ?>:
                        <span id="fileSize"></span>
                    </p>
                    <p class="fileInfoTitle">
                        <?php echo $view['translator']->trans('mediaList.fileTyp'); ?>:
                        <span id="fileTyp"></span>
                    </p>
                    <p class="fileInfoTitle">
                        <?php echo $view['translator']->trans('mediaList.fileDimensions'); ?>:
                        <span id="fileDimensionsW"></span> / <span id="fileDimensionsH"></span>
                    </p>
                    <label class="copyURL">
                        <?php echo $view['translator']->trans('mediaList.fileUrl'); ?>
                        <input type="text" class="fileInfo" id="fileUrl" readonly="readonly">
                        <div class="infoCopyUrl">
                            <span><?php echo $view['translator']->trans('mediaList.copyUrlInfo'); ?></span>
                        </div>
                    </label>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var directory = '<?php echo $view['request']->getParameter('directory'); ?>';
</script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/media.js') ?>" type="text/javascript"></script>

<?php $view['slots']->stop() ?>
