<?php
$folderBlockTable = ['Auction', 'Gallery', 'Goal', 'News', 'Blog', 'Banner', 'Commercial', 'User'];
?>
<div class="row">
    <div class="columns small-12 medium-5 large-4 medium-push-7 large-push-8 fileInfoBoxColumns" data-sticky-container>
        <div class="box fileInfoBox sticky" data-sticky data-margin-top="0">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <div class="pull-right box-tools">
            <span class="box-btn ukryty configFileInfo" data-toggle="configFileInfo-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                    <div class="dropdown-pane configBoxButtons configBoxButtonsTinyMCE" data-position="bottom" data-alignment="right" id="configFileInfo-dropdown" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($permission->isGranted('ROLE_MEDIA_EDIT')): ?>
                                <li>
                                    <a id="insertButton" class="">
                                <span>
                                    <i class="icon-upload"></i>
                                    <?php echo $translator->trans('media.insert'); ?>
                                </span>
                                    </a>
                                </li>
                                <?php if(!in_array(strstr($directory,'/', true), $folderBlockTable)): ?>
                                    <li>
                                        <a id="renameButton" class=" " aria-haspopup="true" tabindex="0">
                                    <span>
                                        <i class="icon-exchange-1"></i>
                                        <?php echo $translator->trans('mediaList.changeName'); ?>
                                    </span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <a id='downloadButton' download="download" href="" class=" ">
                                <span>
                                    <i class="icon-download"></i>
                                    <?php echo $translator->trans('mediaList.download'); ?>
                                </span>
                                    </a>
                                </li>
                                <?php if(!in_array(strstr($directory,'/', true), $folderBlockTable)): ?>
                                    <li>
                                        <a id="deleteButton" aria-haspopup="true" tabindex="0" class="">
                                    <span>
                                        <i class="icon-cancel-circled"></i>
                                        <?php echo $translator->trans('mediaList.delete'); ?>
                                    </span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>

                <h3 class="box-title">
                    <i class="icon-docs"></i>
                    <span><?php echo $translator->trans('mediaList.listSubTitleInfo'); ?></span>
                </h3></div>
            <!-- /.box-header -->
            <div class="box-body collapsed-box" style="display: none">
                <div class="row columns fileInfoBox1">
                    <div id="imgFileInfo">
                        <img src="" id="fileImg">
                    </div>
                    <a id="insertButtonLink" class="hollow button secondary">
                        <span>
                            <i class="icon-upload"></i>
                            <?php echo $translator->trans('media.insert'); ?>
                        </span>
                    </a>
                    <div class="fileInfoText">
                        <p class="fileInfoTitle">
                            <?php echo $translator->trans('mediaList.fileName'); ?>:
                            <span id="fileName"></span>
                        </p>
                        <p class="fileInfoTitle">
                            <?php echo $translator->trans('mediaList.fileSize'); ?>:
                            <span id="fileSize"></span>
                        </p>
                        <p class="fileInfoTitle">
                            <?php echo $translator->trans('mediaList.fileTyp'); ?>:
                            <span id="fileTyp"></span>
                        </p>
                        <p class="fileInfoTitle">
                            <?php echo $translator->trans('mediaList.fileDimensions'); ?>:
                            <span id="fileDimensions"></span>
                        </p>
                        <label class="copyURL">
                            <?php echo $translator->trans('mediaList.fileUrl'); ?>
                            <input type="text" class="fileInfo" id="fileUrl" readonly="readonly">
                            <div class="infoCopyUrl">
                                <span><?php echo $translator->trans('mediaList.copyUrlInfo'); ?></span>
                            </div>
                        </label>
                    </div>
                </div>
                <div class="row columns copyURLbox">

                </div>
            </div>
        </div>
    </div>
    <div class="columns small-12 medium-7 large-8 medium-pull-5 large-pull-4">
        <div class="box mediaBox">
            <div class="box-header bg-transparent headerNotClick">
                <!-- tools box -->
                <h3 class="box-title">
                    <i class="icon-docs"></i>
                    <span><?php echo $translator->trans('mediaList.listSubTitle'); ?>  -  <?php echo $translator->trans('mediaList.here'); ?>: <span class="youAreHere"><?php echo $translator->trans('mediaList.folderMain'); ?>/<?php echo ($directory=='/' ? '' : $directory ); ?></span> </span>
                </h3></div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
<!--                <p>--><?php //echo $translator->trans('media.info'); ?><!--</p>-->
                <?php if ($directory != '/'): ?>
                    <div class="mediaPlik funkcjonalnosc comeback" data-directory="<?php echo $previousDirectory; ?>">
                        <i class="icon-left-bold-1"></i>
                        <?php echo $translator->trans('mediaList.comeback'); ?>
                    </div>
                <?php endif ?>
                <div class="folderTitle">
                    <p>
                        <?php echo $translator->trans('mediaList.folders'); ?>:
                    </p>
                    <?php if ($permission->isGranted('ROLE_MEDIA_EDIT')): ?>
                        <?php if(!in_array(strstr($directory,'/', true), $folderBlockTable)):  ?>
                            <a class="addFolder button tiny" data-open="addFolder">
                                <i class="icon-folder-add"></i>
                                <?php echo $translator->trans('mediaList.addFolder'); ?>
                            </a>
                            <div class="tiny reveal" id="addFolder" data-reveal>
                                <form name="" method="post" class="zmiennazwe" id="nameNewFolderSend" data-directory="<?php echo $directory; ?>">
                                    <input id="nameNewFolder" name="name" required="required" maxlength="100" placeholder="<?php echo $translator->trans('mediaList.nameFolder'); ?>" type="text">
                                    <button type="submit" class="button float-right"><?php echo $translator->trans('Form.create'); ?></button>
                                </form>
                                <button class="close-button addFolderClose" aria-label="Close modal" type="button">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <div class="folderBlock">
                    <?php $j=0;?>
                    <?php foreach ($directories as $i => $direct): ?>
                        <?php $j++; ?>
                        <div class="mediaPlik folderPlik"
                             data-directory="<?php echo $direct->directory; ?>"
                             data-filename="<?php echo $direct->getFilename(); ?>"
                             data-link="<?php echo $direct->link; ?>">
                            <div class="clickMedia" data-directory="<?php echo $direct->directory; ?>">
                                <div class="obiektMedia obiektFolder" data-directory="<?php echo $direct->directory; ?>">
                                    <i class="icon-folder-open-empty"></i>
                                    <?php echo $direct->getFilename(); ?>
                                </div>
                            </div>
                            <?php if ($permission->isGranted('ROLE_MEDIA_EDIT')): ?>
                                <?php if(in_array(strstr($directory,'/', true), $folderBlockTable) || in_array($direct->getFilename(), $folderBlockTable)): ?>

                                <?php else: ?>
                                    <div class="opcje">
                                        <button type="button" class="float-right opcjeFolderuButton buttonOpcje" data-id="opcjeFolderu<?php echo $j; ?>">
                                            <i class="icon-cog-5"></i>
                                        </button>
                                        <div class="dropdown-pane left opcjePliku configBoxButtons" id="opcjeFolderu<?php echo $j; ?>" data-dropdown data-position="bottom" data-alignment="right" data-close-on-click="true">
                                            <ul class="no-bullet">
                                                <li>
                                                    <a class="openDeleteFolder" data-id="deleteFolder<?php echo $j; ?>">
                                                    <span>
                                                        <i class="icon-cancel-circled"></i>
                                                        <?php echo $translator->trans('mediaList.delete'); ?>
                                                    </span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="changeNameFolder" data-id="zmiennazwe<?php echo $j; ?>">
                                                    <span>
                                                        <i class="icon-exchange-1"></i>
                                                        <?php echo $translator->trans('mediaList.changeName'); ?>
                                                    </span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="tiny reveal changeFolderModal" id="zmiennazwe<?php echo $j; ?>" data-reveal>
                            <form name="" method="post" class="zmiennazwe changeFolderForm" data-id-new="reName<?php echo $j; ?>" data-id-old="oldName<?php echo $j; ?>" data-directory="<?php echo $directory; ?>">
                                <input type="hidden" name="oldName" id="oldName<?php echo $j; ?>" required value="<?php echo str_replace('.' . preg_replace('/^.*\./', '', $direct->getFilename()), '', $direct->getFilename()) ?>">
                                <input type="text" name="name" id="reName<?php echo $j; ?>" required value="<?php echo str_replace('.' . preg_replace('/^.*\./', '', $direct->getFilename()), '', $direct->getFilename()) ?>">
                                <button type="submit" class="button float-right"><?php echo $translator->trans('Form.send'); ?></button>
                            </form>
                            <button class="close-button closeChangeFolderModal" data-id="zmiennazwe<?php echo $j; ?>" aria-label="Close modal" type="button">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="tiny reveal deleteFolderModal" id="deleteFolder<?php echo $j; ?>" data-reveal>
                            <form method="post" class="deleteFolderButton" data-directory="<?php echo $directory; ?>" data-id="deleteForm<?php echo $j; ?>">
                                <input type="hidden" name="deleteForm" id="deleteForm<?php echo $j; ?>" required value="<?php echo $direct->getFilename(); ?>",>
                                <div class="switch-admin">
                                    <p><?php echo $translator->trans('mediaList.confirmTextFolder'); ?></p>
                                    <input type="checkbox" name="deleteConfirm" id="deleteConfirm<?php echo $j; ?>" required class="switch-input">
                                    <label class="switch-paddle" for="deleteConfirm<?php echo $j; ?>">
                                        <span class="show-for-sr"><?php echo $translator->trans('mediaList.confirmTextFolder'); ?></span>
                                        <span class="switch-active" aria-hidden="true"><?php echo $translator->trans('yes'); ?></span>
                                        <span class="switch-inactive" aria-hidden="true"><?php echo $translator->trans('no'); ?></span>
                                    </label>
                                    <button type="submit" class="button alert tiny float-right"><i class="icon-cancel-circled"></i><?php echo $translator->trans('mediaList.confirmDelete'); ?></button>
                                </div>
                            </form>
                            <button class="close-button closeDeleteFolder" data-id="deleteFolder<?php echo $j; ?>" aria-label="Close modal" type="button">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endforeach ?>
                </div>
                <div class="folderTitle">
                    <p>
                        <?php echo $translator->trans('mediaList.files'); ?>:
                    </p>
                </div>
                <div class="filesBlock">
                    <?php $k=$j+1; ?>
                    <?php foreach ($files as $i => $file): ?>
                        <?php $k++; ?>
                        <div class="mediaPlik plikPlik file"
                             data-directory="<?php echo $file->directory; ?>"
                             data-filename="<?php echo $file->getFilename(); ?>"
                             data-link="<?php echo $file->link; ?>"
                             data-size="<?php echo $file->size; ?>"
                             data-mime-type="<?php echo $file->getMimeType(); ?>"
                             data-dimensions="<?php echo $file->dimensions; ?>"
                             data-i="<?php echo $k; ?>">
                            <div class="clickMediaPlik"
                                 data-directory="<?php echo $file->directory; ?>"
                                 data-filename="<?php echo $file->getFilename(); ?>"
                                 data-link="<?php echo $file->link; ?>"
                                 data-size="<?php echo $file->size; ?>"
                                 data-mime-type="<?php echo $file->getMimeType(); ?>"
                                 data-dimensions="<?php echo $file->dimensions; ?>"
                                 data-i="<?php echo $k; ?>">
                                <div class="obiektMedia">
                                    <?php if($file->getExtension()=='png'): ?>
                                        <img src="<?php echo $file->link; ?>">
                                    <?php elseif ($file->getExtension()=='jpg'): ?>
                                        <img src="<?php echo $file->link; ?>">
                                    <?php elseif ($file->getExtension()=='jepg'): ?>
                                        <img src="<?php echo $file->link; ?>">
                                    <?php elseif ($file->getExtension()=='avi'): ?>
                                        <i class="icon-file-video"></i>
                                    <?php elseif ($file->getExtension()=='mp3'): ?>
                                        <i class="icon-file-audio"></i>
                                    <?php elseif ($file->getExtension()=='mp4'): ?>
                                        <i class="icon-file-video"></i>
                                    <?php elseif ($file->getExtension()=='pdf'): ?>
                                        <i class="icon-file-pdf"></i>
                                    <?php elseif ($file->getExtension()=='rar'): ?>
                                        <i class="icon-file-archive"></i>
                                    <?php elseif ($file->getExtension()=='zip'): ?>
                                        <i class="icon-file-archive"></i>
                                    <?php else: ?>
                                        <i class="icon-doc"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="tytulPliku">
                                    <?php echo $file->getFilename(); ?>
                                </div>
                            </div>
                            <div class="obiektMediaHover text-center">
                                <button class="button tiny insertButtonFileHover" data-link="<?php echo $file->link; ?>" data-filename="<?php echo $file->getFilename(); ?>"><?php echo $translator->trans('mediaList.insert'); ?></button>
                            </div>
                            <div class="kreska"></div>
                            <div class="opcje">
                                <button type="button" class="float-right opcjeFolderuButton buttonOpcje" data-id="opcje<?php echo $k; ?>"><i class="icon-cog-5"></i> </button>
                                <div class="dropdown-pane bottom opcjePliku configBoxButtons" id="opcje<?php echo $k; ?>" data-dropdown>
                                    <ul class="no-bullet">
                                        <?php if ($permission->isGranted('ROLE_MEDIA_EDIT')): ?>
                                            <?php if(!in_array(strstr($directory,'/', true), $folderBlockTable)):  ?>
                                                <li>
                                                    <a class="deleteFileButton" data-id="deleteFile<?php echo $k; ?>">
                                                    <span>
                                                        <i class="icon-cancel-circled"></i>
                                                        <?php echo $translator->trans('mediaList.delete'); ?>
                                                    </span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="renameFileButton" data-id="renameFile<?php echo $k; ?>">
                                                    <span>
                                                        <i class="icon-exchange-1"></i>
                                                        <?php echo $translator->trans('mediaList.changeName'); ?>
                                                    </span>
                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <li>
                                            <a href="<?php echo $file->link; ?>" class="downloadFile" download="<?php echo $file->getFilename(); ?>">
                                            <span>
                                                <i class="icon-download"></i>
                                                <?php echo $translator->trans('mediaList.download'); ?>
                                            </span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="tiny reveal deleteFileModal" id="deleteFile<?php echo $k; ?>" data-reveal>
                            <form name="deleteFile" class="deleteFileForm" data-id="deleteFileId<?php echo $k; ?>" data-directory="<?php echo $directory; ?>">
                                <input type="hidden" name="deleteFile" id="deleteFileId<?php echo $k; ?>" required
                                       value="<?php echo $file->getFilename(); ?>">
                                <div class="switch-admin">
                                    <p><?php echo $translator->trans('mediaList.confirmTextFile'); ?></p>
                                    <input type="checkbox" name="deleteConfirm" id="deleteConfirm<?php echo $k; ?>" class="switch-input" required>
                                    <label class="switch-paddle" for="deleteConfirm<?php echo $k; ?>">
                                        <span class="show-for-sr"><?php echo $translator->trans('mediaList.confirmTextFile'); ?></span>
                                        <span class="switch-active" aria-hidden="true"><?php echo $translator->trans('yes'); ?></span>
                                        <span class="switch-inactive" aria-hidden="true"><?php echo $translator->trans('no'); ?></span>
                                    </label>
                                    <button type="submit" class="button alert tiny float-right"><i class="icon-cancel-circled"></i><?php echo $translator->trans('mediaList.confirmDelete'); ?></button>
                                </div>
                            </form>
                            <button class="close-button deleteFileModalClose" data-id="deleteFile<?php echo $k; ?>" aria-label="Close modal" type="button">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="tiny reveal renameFileModal" id="renameFile<?php echo $k; ?>" data-reveal>
                            <form name="reName" data-directory="<?php echo $directory; ?>" class="zmiennazwe renameFileModalForm" data-id-new="newName<?php echo $k; ?>" data-id-old="oldName<?php echo $k; ?>">
                                <input type="hidden" name="oldName" id="oldName<?php echo $k; ?>" required value="<?php echo $file->getFilename(); ?>">
                                <input type="text" name="name" id="newName<?php echo $k; ?>" required value="<?php echo str_replace('.' . preg_replace('/^.*\./', '', $file->getFilename()), '', $file->getFilename()) ?>">
                                <button type="submit" class="button float-right"><?php echo $translator->trans('Form.send'); ?></button>
                            </form>
                            <button class="close-button renameFileModalClose" data-id="renameFile<?php echo $k; ?>" aria-label="Close modal" type="button">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endforeach ?>
                    <?php if ($permission->isGranted('ROLE_MEDIA_EDIT')): ?>
                        <?php if(!in_array(strstr($directory,'/', true), $folderBlockTable)):  ?>
                            <div class="mediaPlik addPlik" id="uploaderFile" data-directory="<?php echo $directory; ?>">
                                <div id="drop-area" style="">
                                    <b><span id="percent"></span></b>
                                    <span class="block text-ellipsis" id="choosen-file"></span><br>
                                </div>
                            </div>
                            <hr>
                            <div class="row columns pojedynczyFormularz">
                                <p><?php echo $translator->trans('mediaList.simpleForm'); ?>:</p>
                                <form action="<?php echo $this->get('router')->generate('wi_admin_media_upload', ['ref' => 1]); ?>" enctype="multipart/form-data" method="post" id="fileAdd" data-directory="<?php echo $directory; ?>">
                                    <input type="file" name="file" accept=".avi,.jpeg,.jpg,.mp3,.mp4,.pdf,.png,.rar,.zip">
                                    <button type="submit" class="button"><i class="icon-upload"></i> <?php echo $translator->trans('Form.send2'); ?></button>
                                </form>
                            </div>
                        <?php endif; ?>


                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
/*
Request Variables:
directory: data-dirname
*/
?>