<?php

namespace Wi\Admin\MenuBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Wi\Admin\CoreBundle\Service\Seo;
use Wi\Admin\NewsBundle\Entity\Category;
use Wi\Admin\NewsBundle\Entity\News;
use Wi\Admin\ContactBundle\Entity\Form;

/**
 * LinkGenerator controller.
 *
 * @author Piotr Krzok <piotr.krzok@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LinkGeneratorController extends Controller
{
    /**
     * Lista modułów menu.
     *
     * @return JsonResponse
     */
    public function modulesAction()
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        $modules = $em->getRepository('WiAdminMenuBundle:ItemModule')->findAll();
        $out = [];

        foreach ($modules as $module) {
            $out[$module->getId()] = $module->getName();
        }

        return new JsonResponse($out);
    }

    /**
     * Generowanie linku na podstawie przekazanego modułu i ewentualnego elementu.
     *
     * Parametry:
     *      module - ID modułu
     *      item - ID elementu z danego modułu
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function linkAction(Request $request, Seo $seo)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $module = $request->request->getInt('module');
        $item = $request->request->getInt('item');
        $linkTo = $request->request->getInt('link_to') ? $request->request->getInt('link_to') : 1;
        $out = [
            'url' => null,
        ];

        if ($module = $em->getRepository('WiAdminMenuBundle:ItemModule')->find($module)) {
            switch ($module->getId()) {
                case 1: // Strona główna.
                    $out['url'] = $this->generateUrl($module->getRoute(), [], UrlGeneratorInterface::ABSOLUTE_URL);
                    break;
                case 2: // Strona.
                    $obj = $em->getRepository('WiAdminPageBundle:Page')->find($item);
                    $out['url'] = ! empty($metas = $seo->getMetaArrayValues($obj)) ? $metas['canonical'] : null;
                    break;
                case 3: // Aktualności.
                    switch ($linkTo) {
                        case 1: // Kategorie aktualności.
                            $obj = $em->getRepository('WiAdminNewsBundle:Category')->find($item);
                            $out['url'] = ! empty($metas = $seo->getMetaArrayValues($obj)) ? $metas['canonical'] : null;
                            break;
                        case 2: // Aktualność.
                            $obj = $em->getRepository('WiAdminNewsBundle:News')->find($item);
                            $out['url'] = ! empty($metas = $seo->getMetaArrayValues($obj)) ? $metas['canonical'] : null;
                            break;
                    }
                    break;
                case 4: // Blog.
                    switch ($linkTo) {
                        case 1: // Kategorie.
                            $obj = $em->getRepository('WiAdminNewsBundle:Category')->find($item);
                            $out['url'] = ! empty($metas = $seo->getMetaArrayValues($obj)) ? $metas['canonical'] : null;
                            break;
                        case 2: // Wpisy.
                            $obj = $em->getRepository('WiAdminNewsBundle:News')->find($item);
                            $out['url'] = ! empty($metas = $seo->getMetaArrayValues($obj)) ? $metas['canonical'] : null;
                            break;
                    }
                    break;
                case 5: // Moje linki.
                    $obj = $em->getRepository('WiAdminLinkBundle:Link')->find($item);
                    $out['url'] = $this->generateUrl($module->getRoute(), ['code' => $obj->getCode()], UrlGeneratorInterface::ABSOLUTE_URL);
                    break;
                case 6: // Formularze kontaktowe.
                    switch ($linkTo) {
                        case 1: // Kontakt.
                            $out['url'] = $this->generateUrl($module->getRoute(), [], UrlGeneratorInterface::ABSOLUTE_URL);
                            break;
                        case 2: // Formularz kontaktowy.
                        case 3: // Formularz leadów.
                            $obj = $em->getRepository('WiAdminContactBundle:Form')->find($item);
                            $out['url'] = ! empty($metas = $seo->getMetaArrayValues($obj)) ? $metas['canonical'] : null;
                            break;
                    }
                    break;
            }
        }

        $out['url'] = str_replace($this->generateUrl('homepage', [], UrlGeneratorInterface::ABSOLUTE_URL), '/', $out['url']);

        return new JsonResponse($out);
    }

    /**
     * Generowanie listy elementów na podstawie przekazanego modułu.
     *
     * Parametry:
     *      module - ID modułu
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function itemsAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $module = $request->request->getInt('module');
        $linkTo = $request->request->getInt('link_to') ? $request->request->getInt('link_to') : 1;
        $out = [
            'items' => [],
            'link_to' => [],
            'link_to_active' => $linkTo,
        ];

        if ($module = $em->getRepository('WiAdminMenuBundle:ItemModule')->find($module)) {
            switch ($module->getId()) {
                case 1: // Strona główna.
                    // no break
                    break;
                case 2: // Strona.
                    $pages = $em->getRepository('WiAdminPageBundle:Page')->findForSitemap([2]);

                    foreach ($pages as $page) {
                        $out['items'][] = [
                            'id' => $page->getId(),
                            'title' => $page->getTitle(),
                        ];
                    }
                    break;
                case 3: // Aktualności.
                    $out['link_to'] = [
                        ['id' => 1, 'title' => 'Kategoria'],
                        ['id' => 2, 'title' => 'Konkretna aktualność'],
                    ];

                    switch ($linkTo) {
                        case 1: // Kategorie aktualności.
                            $categories = $em->getRepository('WiAdminNewsBundle:Category')->findByType(Category::TYPE_NEWS);

                            foreach ($categories as $category) {
                                $out['items'][] = [
                                    'id' => $category->getId(),
                                    'title' => $category->getName(),
                                ];
                            }
                            break;
                        case 2: // Aktualność.
                            $news = $em->getRepository('WiAdminNewsBundle:News')->findByType(News::TYPE_NEWS);

                            foreach ($news as $News) {
                                $out['items'][] = [
                                    'id' => $News->getId(),
                                    'title' => $News->getTitle(),
                                ];
                            }
                            break;
                    }

                    break;
                case 4: // Blog.
                    $out['link_to'] = [
                        ['id' => 1, 'title' => 'Kategoria'],
                        ['id' => 2, 'title' => 'Konkretny wpis'],
                    ];

                    switch ($linkTo) {
                        case 1: // Kategorie blog.
                            $categories = $em->getRepository('WiAdminNewsBundle:Category')->findByType(Category::TYPE_BLOG);

                            foreach ($categories as $category) {
                                $out['items'][] = [
                                    'id' => $category->getId(),
                                    'title' => $category->getName(),
                                ];
                            }
                            break;

                        case 2: // Wpis.
                            $news = $em->getRepository('WiAdminNewsBundle:News')->findByType(News::TYPE_BLOG);

                            foreach ($news as $News) {
                                $out['items'][] = [
                                    'id' => $News->getId(),
                                    'title' => $News->getTitle(),
                                ];
                            }
                            break;
                    }

                    break;
                case 5: // Moje linki.
                    $links = $em->getRepository('WiAdminLinkBundle:Link')->findAll();

                    foreach ($links as $link) {
                        $out['items'][] = [
                            'id' => $link->getId(),
                            'title' => $link->getUrl(),
                        ];
                    }
                    break;
                case 6: // Formularze kontaktowe.
                    $out['link_to'] = [
                        ['id' => 1, 'title' => 'Kontakt'],
                        ['id' => 2, 'title' => 'Formularz kontaktowy'],
                        ['id' => 3, 'title' => 'Formularz leadów'],
                    ];

                    switch ($linkTo) {
                        case 2: // Formularz kontaktowy.
                            $forms = $em->getRepository('WiAdminContactBundle:Form')->findByFormType(Form::TYPE_CONTACT);

                            foreach ($forms as $form) {
                                $out['items'][] = [
                                    'id' => $form->getId(),
                                    'title' => $form->getName(),
                                ];
                            }
                            break;
                        case 3: // Formularz leadów.
                            $forms = $em->getRepository('WiAdminContactBundle:Form')->findByFormType(Form::TYPE_LEAD);

                            foreach ($forms as $form) {
                                $out['items'][] = [
                                    'id' => $form->getId(),
                                    'title' => $form->getName(),
                                ];
                            }
                            break;
                    }
                    break;
            }
        }

        return new JsonResponse($out);
    }
}
