<?php

namespace Wi\Admin\MenuBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Wi\Admin\MenuBundle\Entity\Location;

/**
 * Załadowanie danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadLocationData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $location = $this->getCategory($data);
            $this->addReference('mb-location-'.$data['id'], $location);

            // Przygotowanie do zapisu.
            $manager->persist($location);

            // Wymuszenie podania ID.
            $metadata = $manager->getClassMetaData(get_class($location));
            $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 41;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            [
                'id' => 1,
                'name' => 'Menu główne',
            ],
            [
                'id' => 2,
                'name' => 'Menu stopka 1',
            ],
            [
                'id' => 3,
                'name' => 'Menu stopka 2',
            ],
            [
                'id' => 4,
                'name' => 'Menu stopka 3',
            ],
            [
                'id' => 5,
                'name' => 'Menu Error (Error Pages 404 & 500)',
            ]
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\NewsBundle\Entity\Category
     */
    private function getCategory(array $data)
    {
        return (new Location())
            ->setId($data['id'])
            ->setName($data['name'])
        ;
    }
}
