<?php

namespace Wi\Admin\MenuBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\MenuBundle\Entity\ItemMenu;

/**
 * Menu Item Listener.
 *
 * Słuchacz zdarzeń dla encji ItemMenu.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ItemMenuListener
{
    /**
     * Metoda wykonywana jest przed wstawieniem nowego elementu do bazy.
     * Ustawia datę utworzenia oraz kolejność elementów.
     *
     * @param LifecycleEventArgs $event
     */
    public function prePersist(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();

        if (! $entity instanceof ItemMenu) {
            return;
        }

        // Ustawienie daty utworzenia.
        $entity->setDateCreated(new \DateTime());

        // Ustawienie kolejności elementów.
        $entity->setOrderNr(
            $args->getEntityManager()
                ->getRepository('WiAdminMenuBundle:ItemMenu')
                ->getLastOrderIncrement($entity)
        );
    }

    /**
     * Metoda wykonywana jest przed usunięciem obiektu. Aktualizuje status
     * obiektu na usunięty.
     *
     * @param LifecycleEventArgs $event
     */
    public function preRemove(LifecycleEventArgs $args)
    {
        $entity = $args->getEntity();

        if (! $entity instanceof ItemMenu) {
            return;
        }

        // Ustawienie statusu na usunięty.
        $entity->setStatus(ItemMenu::STATUS_DELETED);

        // Zapis.
        $em = $args->getEntityManager();
        $em->persist($entity);
        $em->flush();
    }
}
