<?php

namespace Wi\Admin\MenuBundle\Menu;

use Knp\Menu\FactoryInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;

/**
 * Builder menu.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class Builder implements ContainerAwareInterface
{
    use ContainerAwareTrait;

    /**
     * Create menu.
     *
     * @param FactoryInterface $factory
     * @param array $options
     * @return \Knp\Menu\ItemInterface
     */
    public function createMainMenu(FactoryInterface $factory, array $options)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->container->get('doctrine.orm.entity_manager');

        $menu = $factory->createItem('mainMenu', [
            'childrenAttributes' => [
                'class' => 'menu links',
                'data-dropdown-menu' => false
            ]
        ]);

        // Pobranie listy menu z danej lokalizacji.
        $location = $options['idLocations'];
        $menuItems = $em->getRepository('WiAdminMenuBundle:ItemMenu')
            ->findAllActiveWithoutParent($location)
        ;

        // Generowanie drzewa menu.
        $this->buildTree($menuItems, $menu);

        return $menu;
    }

    /**
     * Generowanie drzewa menu.
     *
     * @param array $menuItems
     * @param MenuItem $menu
     */
    private function buildTree($items, $menu)
    {
        if (! is_array($items)) {
            return;
        }

        $base_url = $this->container->getParameter('base_url');

        foreach ($items as $item) {
            $key = 'item_' . $item->getId();
            $menu
                ->addChild($key, [
                    'uri' => $base_url.$item->getUrl(),
                    'label' => $item->getName(),
                ])
                ->setExtra('translation_domain', false)
            ;

            $menu[$key]->setLinkAttributes([
                'title' => $item->getTitle() ?: $item->getName(),
                'target' => $item->getExternal() ? '_blank' : null,
            ]);

            // Utworzenie instancji EntityManager-a.
            $em = $this->container->get('doctrine.orm.entity_manager');

            // Pobranie dzieci.
            $children = $em->getRepository('WiAdminMenuBundle:ItemMenu')
                ->findAllActiveChildren($item->getId())
            ;

            // Generowanie podmenu.
            $this->buildTree($children, $menu[$key]);
        }
    }
}
