<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_menu_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.menu.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/menu.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_menu_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.menu.List'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-menu"></i>
    <?php echo $view['translator']->trans('menu.listTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('menuList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php
    /**
     * Render menu tree.
     *
     * @return string
     */
    $displayMenuTree = function ($menu, $prefix = '', $html = '', $location) use (&$displayMenuTree, $view) {
        $html .= '
                    <ol class="dd-list">';
        foreach ($menu as $key => $item) {
            $html .= '
                        <li class="dd-item" data-id="' . $item->getId() . '">
                            <div class="dd-handle';
            if($item->getStatus()=="N"){
                $html .= ' InActiv ';
            }
            $html .='">' . $item->getName() . '</div>
                             ';
            if ($view['security']->isGranted('ROLE_MENU_EDIT')){
                $html .= '
                    <div class="akcje">
                                <a href="' . $view['router']->path('wi_admin_menu_edit', ["id" => $item->getId()]) . '" class="tooltipster-top" title="' . $view['translator']->trans('menuList.edit') . '">
                                    <i class="icon-edit-1"></i>
                                </a>
                                <a href="' . $view['router']->path('wi_admin_menu_new', ["parent_id" => $item->getId(), "location_id" => $location]) . '" class="tooltipster-top" title="' . $view['translator']->trans('menuList.add') . '">
                                    <i class="icon-list-add"></i>
                                </a>
                                <a href="' . $view['router']->path('wi_admin_menu_delete', ["id" => $item->getId()]) . '" class="tooltipster-top" title="' . $view['translator']->trans('menuEdit.deleteButton') . '">
                                    <i class="icon-cancel-circled-outline"></i>
                                </a>
                            </div>
                ';
            }
            // Jeśli są dzieci.
            if ($item->getChildren()->count()) {
                $html .= $displayMenuTree($item->getChildren(), $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', null, $location);
            }

            $html .= '
                        </li>
                ';
        }
        $html .= '
                    </ol>
                ';
        return $html;
    };
?>

<?php $view['slots']->start('body') ?>
    <span id="countLocation" data-wartosc="<?php echo $locations->count(); ?>"></span>
    <?php foreach ($locations as $key => $location): ?>
        <div class="box">
            <div class="box-header bg-transparent">
                <!-- tools box -->
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="configMenuLocation-dropdown<?php echo $key; ?>">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configMenuLocation-dropdown<?php echo $key; ?>" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_MENU_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_menu_new', ["location_id" => $location->getId()]); ?>" class="" title="<?php echo $view['translator']->trans('menuList.addButton'); ?>">
                                        <span><i class="icon-list-add"></i>
                                        <?php echo $view['translator']->trans('menuList.addButton'); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <li class="odciecie">
                                <button class="collapseAll" type="button">
                                    <span><i class="icon-collapse"></i><?php echo $view['translator']->trans('pagesList.collapse'); ?></span>
                                </button> /
                                <button class="expandAll" type="button">
                                    <span><i class="icon-expand"></i><?php echo $view['translator']->trans('pagesList.expand'); ?></span>
                                </button>
                            </li>
                        </ul>
                    </div>
                    <span>
                        <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                    </span>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-menu"></i>
                    <span><?php echo $location->getName(); ?></span>
                </h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="columns">
                        <div class="listMenu">
                            <div class="dd nestable" <?php echo $view['security']->isGranted('ROLE_MENU_EDIT') ? 'id="nestableM' . $key . '"' : ''; ?>>
                                <?php $locationWithOutChildren = []; ?>
                                <?php foreach ($location->getItems() as $item): ?>
                                    <?php if(is_null($item->getParent())): ?>
                                        <?php $locationWithOutChildren[] = $item; ?>
                                        <?php endif; ?>
                                <?php endforeach; ?>
                                <?php echo $displayMenuTree($locationWithOutChildren, null, null, $location->getId()); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/nestable/jquery.nestable.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/menu.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
