<?php

namespace Wi\Admin\NewsBundle\Controller;

use Knp\Component\Pager\Paginator;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\CoreBundle\Form\DeleteType;
use Wi\Admin\NewsBundle\Entity\Comment;
use Wi\Admin\NewsBundle\Form\CommentType;

/**
 * Comment controller.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2018 WEBimpuls Sp. z o.o.
 */
class CommentController extends Controller
{
    /**
     * Lista komentarzy.
     *
     * @param Paginator $paginator
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function indexAction(Paginator $paginator, Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $comments = $paginator->paginate(
            $em->getRepository('WiAdminNewsBundle:Comment')->getAllQuery(),
            $request->query->getInt('page', 1),
            $request->query->getInt('per_page') ?: 10,
            [
                'defaultSortDirection' => 'desc',
                'defaultSortFieldName' => 'c.dateCreated',
                'wrap-queries' => true,
            ]
        );

        return $this->render('WiAdminNewsBundle:Comment:index.html.php', [
            'comments' => $comments,
        ]);
    }

    /**
     * Edycja komentarza.
     *
     * @param Request $request
     * @param Comment $comment
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function editAction(Request $request, Comment $comment)
    {
        $form = $this->createForm(CommentType::class, $comment);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($comment);
            $em->flush();

            return $this->redirectToRoute('wi_admin_news_comment_index');
        }

        return $this->render('WiAdminNewsBundle:Comment:edit.html.php', [
            'comment' => $comment,
            'form' => $form->createView(),
        ]);
    }

    /**
     * Usuwanie komentarzy.
     *
     * @param Request $request
     * @param Comment $comment
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function deleteAction(Request $request, Comment $comment)
    {
        $form = $this->createForm(DeleteType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();
            $em->remove($comment);
            $em->flush();

            return $this->redirectToRoute('wi_admin_news_comment_index');
        }

        return $this->render('WiAdminNewsBundle:Comment:delete.html.php', [
            'comment' => $comment,
            'form' => $form->createView(),
        ]);
    }
}
