<?php

namespace Wi\Admin\NewsBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\NewsBundle\Entity\Comment;

class CommentType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $comment = $builder->getData();

        $builder
            ->add('content', TextareaType::class, [
                'attr' => [
                    'rows' => 5,
                ],
            ])
            ->add('status', ChoiceType::class, [
                'choices' => [
                    'comment.form.status.options.active' => Comment::STATUS_ACTIVE,
                    'comment.form.status.options.hidden' => Comment::STATUS_HIDDEN,
                    'comment.form.status.options.spam' => Comment::STATUS_SPAM,
                    'comment.form.status.options.wait' => Comment::STATUS_WAIT,
                ],
                'choice_translation_domain' => 'news_comment',
            ])
        ;

        if (! is_null($comment->getGuest())) {
            $builder
                ->add('guestName', TextType::class, [
                    'property_path' => 'guest.name',
                ])
            ;
        }
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Comment::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_news_comment';
    }
}
