<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_blog_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.blog.newsDelete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.news'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_delete', array('id' => $news->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.newsDelete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i><?php echo $view['translator']->trans('blog.listTitle'); ?> - <?php echo $view['translator']->trans('blogDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('blogDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('blogDelete.listSubTitle'); ?> - <?php echo $news->getTitle(); ?></span>
        </h3></div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('blogDelete.dataNews'); ?></strong></p>

                <?php echo $view['form']->start($deleteForm); ?>
                <?php echo $view['form']->errors($deleteForm); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($deleteForm['deleteNews']); ?>
                    <?php echo $view['form']->widget($deleteForm['deleteNews']); ?>
                    <label class="switch-paddle" for="<?php echo $deleteForm->children['deleteNews']->vars['id']; ?>">
                        <span class="show-for-sr"><?php echo $view['translator']->trans('blogDelete.dataNews'); ?></span>
                        <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                        <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                    </label>
                </div>
                <p><?php echo $view['translator']->trans('blogDelete.dataNewsSub'); ?>:<br>
                    <strong><?php echo $view['translator']->trans('newsNew.form.titleTitle'); ?></strong> <?php echo $news->getTitle() ?><br>
                    <strong><?php echo $view['translator']->trans('newsNew.form.shortTitle'); ?></strong> <?php echo $news->getShortcut() ?><br>
                </p>
                <button type="submit" id="NewsDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_blog_show', array('id' => $news->getId())); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($deleteForm); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
