<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_blog_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.blog.newsEdit')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>">
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.news'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_blog_edit', array('id' => $news->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.newsEdit'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i><?php echo $view['translator']->trans('blog.listTitle'); ?> - <?php echo $view['translator']->trans('blogEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('blogEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('blogEdit.boxTitle'); ?> - <?php echo $news->getTitle(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'newsNew' ))); ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.titleTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.titleDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['title']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['title'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['title'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.shortTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.shortDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['shortcut']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['shortcut']) ? $view['form']->widget($form['shortcut'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['shortcut'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.textTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.textDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert <?php echo ($view['form']->errors($form['content']) ? "callout alert" : ""); ?>">
                                <?php echo $view['form']->errors($form['content']); ?>
                            </div>
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($form['content']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
        </div>
    </div>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('blogEdit.box2Title'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.movieTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.movieDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['movie']); ?>
                    </div>
                    <?php echo ($view['form']->errors($form['movie']) ? $view['form']->widget($form['movie'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['movie'])); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.catTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.catDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['categories']); ?>
                            </div>
                            <div class="formAlert callout alert" id="contentValidationCat">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['categories']) ? $view['form']->widget($form['categories'], array('attr' => array('class' =>'callout alert chosenSelectCategory'))) : $view['form']->widget($form['categories'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.tagTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.tagDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <button class="addTag button tiny secondary <?php echo $news->getTags()->count() > 0 ? 'hide' : '' ?>" type="button"><span><?php echo $view['translator']->trans('blogEdit.form.buttonAddTag'); ?></span></button>
                            <div class="formAddTags <?php echo $news->getTags()->count() > 0 ? '' : 'hide' ?>">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['tags']); ?>
                                </div>
                                <?php echo $view['form']->label($form['tags']); ?>
                                <?php echo ($view['form']->errors($form['tags']) ? $view['form']->widget($form['tags'], array('attr' => array('class' =>'callout alert chosenSelectCategory'))) : $view['form']->widget($form['tags'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.dateTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.dateDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['dateOfPublication']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['dateOfPublication']) ? $view['form']->widget($form['dateOfPublication'], array('attr' => array('class' =>'callout alert datePicker'))) : $view['form']->widget($form['dateOfPublication'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.status'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.statusDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['status']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['status']) ? $view['form']->widget($form['status'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['status'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-download"></i><span><?php echo $view['translator']->trans('newsNew.enableDownloadTitle'); ?></span></h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.enableDownload.title'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.enableDownload.desc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['enableDownload']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['enableDownload']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['enableDownload']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('blogEdit.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('blogEdit.form.metaTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('blogEdit.form.metaDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaTitle']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaTitle']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaTitle']) ? $view['form']->widget($form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaTitle'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaDescription']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaDescription']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaDescription']) ? $view['form']->widget($form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaDescription'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaKeywords']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaKeywords']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaKeywords']) ? $view['form']->widget($form['metaKeywords'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaKeywords'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaCanonical']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaCanonical']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaCanonical']) ? $view['form']->widget($form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaCanonical'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaImage']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaImage']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaImage']) ? $view['form']->widget($form['metaImage'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaImage'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box">
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <?php echo $view['form']->widget($form); ?>
                        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                            <i class="icon-edit"></i>
                            <?php echo $view['translator']->trans('Form.send'); ?>
                        </button>
                        <?php echo $view['form']->end($form); ?>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_blog_show', array('id' => $news->getId())); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-picture"></i> <span><?php echo $view['translator']->trans('blogEdit.form.images'); ?></span>
            </h3>
        </div>
        <div class="box-body " style="display: block;">
            <div id="image-upload-box">
                <?php if ($news->getImages()->count() < 6): ?>
                    <?php echo $view['form']->start($imageForm, ['attr' => ['id' => 'image-upload-form']]); ?>
                        <div class="large reveal" id="windowModalCropper" data-reveal data-close-on-click="false">
                            <div class="containerCropper">
                                <img id="cropperImage" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="">
                            </div>
                            <div class="row buttonAddImage">
                                <div class="medium-12 columns">
                                    <button type="button" class="button" id="Wyslijfoto" data-close aria-label="Close modal"><i class="icon-ok"></i> <?php echo $view['translator']->trans('newsNew.form.saveImage'); ?></button>
                                    <button type="button" class="button secondary float-right"  data-close aria-label="Close modal"><i class="icon-cancel"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></button>
                                </div>
                            </div>
                        </div>

                        <?php echo $view['form']->widget($imageForm['crop_x']); ?>
                        <?php echo $view['form']->widget($imageForm['crop_y']); ?>
                        <?php echo $view['form']->widget($imageForm['crop_height']); ?>
                        <?php echo $view['form']->widget($imageForm['crop_width']); ?>
                        <?php echo $view['form']->widget($imageForm['cropSave']); ?>

                        <?php if($news->getImages()->count() == 0): ?>
                            <img id="cropperPreview" class="previewImage thumbnail"  src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="" data-open="windowModalCropper">
                        <?php endif; ?>
                        <label class="AddImage" for="appbundle_photo_file" >
                            <?php echo $view['form']->widget($imageForm['file']); ?>
                            <span class="button" id="imageDataFromParameter" type="button" cropper-width="<?php echo $view['config']->get('blog.imageWidth'); ?>" cropper-height="<?php echo $view['config']->get('blog.imageHeight'); ?>">
                                    <i class="icon-upload"></i><?php echo $view['translator']->trans('blogEdit.form.addImage'); ?>
                            </span>
                        </label>
                    <?php echo $view['form']->end($imageForm); ?>
                <?php endif; ?>
            </div>
            <hr>
            <ul class="image-list">
            <?php foreach ($news->getImages() as $image): ?>
                <li data-id="<?php echo $image->getId(); ?>">
                    <img src="<?php echo $view['assets']->getUrl('media/assets/Blog/thumbnailS/'.$image->getName()); ?>" alt="">
                    <a href="<?php echo $view['router']->path('wi_admin_blog_delete_image', ['id' => $image->getId()]); ?>" class="remove-image">Usuń</a>
                </li>
            <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jquery-ui-1.12.1/jquery-ui.min.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js') ?>"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
    <script>
        $(function () {
            $('.image-list').sortable({
                placeholder: "image-list-item-placeholder",
                update: function (e, ui) {
                    var sortedIDs = $('.image-list').sortable('toArray', { attribute: 'data-id' });
                    $.ajax({
                        type: 'POST',
                        data: {
                            ids: sortedIDs,
                        },
                        dataType: 'json',
                        url: Routing.generate('wi_admin_news_update_image_order', { id: <?php echo $news->getId(); ?> }),
                        success: function (response) {
                            console.log(response);
                        },
                    });
                },
            }).disableSelection();
        });
    </script>
<?php $view['slots']->stop() ?>
