<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_blog_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.categoryBlog.catList')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.blog.news'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_blog_categories_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.categoryBlog.catList'); ?>
        </a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i>
    <?php echo $view['translator']->trans('blog.listTitle'); ?> - <?php echo $view['translator']->trans('catBlogList.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('catBlogList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <?php
    /**
     * Render categories tree.
     *
     * @return string
     */
    $displayCategoriesTree = function ($categories, $prefix = '', $html = '') use (&$displayCategoriesTree, $view) {
        foreach ($categories as $key => $category) {
            $html .= '
                <tr>
                    <td>' . $prefix . '<i class="icon-down-open-mini" ' . ($category->getChildren()->count() ? '' : 'style="opacity: 0;"') . '></i><a href="' . $view['router']->path('wi_admin_blog_categories_show', ['id' => $category->getId()]) . '" class="" title="' . $view['translator']->trans('catBlogList.showCat') . '" ><b>&nbsp;' . $category->getName() . '</b></a>
                    <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="'. $view['router']->path('wi_admin_blog_categories_show', ['id' => $category->getId()]) .'" class=""><i class="icon-eye-1"></i>'. $view['translator']->trans('Table.showButton') .'</a> / ';
                                if ($view['security']->isGranted('ROLE_BLOG_EDIT')){
                                    $html .= '<a href="' .$view['router']->path('wi_admin_blog_categories_edit', ['id' => $category->getId()]) .'" class=""><i class="icon-edit-1"></i>' .$view['translator']->trans('Table.editButton'). '</a> / ';
                                }
                                if ($view['security']->isGranted('ROLE_BLOG_EDIT')){
                                    $html .= '<a href="' .$view['router']->path('wi_admin_blog_categories_delete', ['id' => $category->getId()]). '" class=""><i class="icon-cancel-circled-outline"></i>' .$view['translator']->trans('Table.deleteButton'). '</a>';
                                }

                        $html .=    '</div></div>
                    </td>
                    <td>' . ($description = substr(trim(strip_tags($category->getDescription())), 0, 200)) . (strlen($description) > 200 ? '...' : '') . '</td>
                    <td>
                        <div class="OrderNrForm">';
                        if (! is_null($categories->get($key - 1))) {
                            $html .= '<div><a href="'.$view['router']->path('wi_admin_blog_categories_update_order', ['id' => $category->getId(), 'sort_dir' => 'up']).'" class="button secondary tiny"><i class="icon-up-big margin-center"></i></a></div>';
                        } else {
                            $html .= '<div><span class="button disabled secondary tiny"><i class="icon-up-big margin-center"></i></span></div>';
                        }

                        if (! is_null($categories->get($key + 1))) {
                            $html .= '<div><a href="'.$view['router']->path('wi_admin_blog_categories_update_order', ['id' => $category->getId(), 'sort_dir' => 'down']).'" class="button secondary tiny"><i class="icon-down-big margin-center"></i></a></div>';
                        } else {
                            $html .= '<div><span class="button disabled secondary tiny"><i class="icon-down-big margin-center"></i></span></div>';
                        }
                $html .= '</div>
                    </td>
                </tr>
            ';

            // Jeśli są podkategorie.
            if ($category->getChildren()->count()) {
                $html .= $displayCategoriesTree($category->getChildren(), $prefix . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
            }
        }

        return $html;
    };
    ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configCategory-dropdown">
                    <i class="icon-cog-5"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOG_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_blog_categories_new') ?>" title="<?php echo $view['translator']->trans('catBlogList.add'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('catBlogList.add'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('catBlogList.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="catList" class="row-border unstriped hover" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('catBlogList.table.name'); ?></th>
                            <th><?php echo $view['translator']->trans('catBlogList.table.description'); ?></th>
                            <th><?php echo $view['translator']->trans('catBlogList.table.OrderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php echo $displayCategoriesTree($categories); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary" href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('catBlogList.backListNews'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
