<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_comment_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('comment.meta.title', [], 'news_comment')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.cmsAdvanced'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_comment_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.comment', [], 'news_comment'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<i class="icon-comment-empty"></i><?php echo $view['translator']->trans('comment.title', [], 'news_comment'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title">
            <i class="icon-comment-empty"></i>
            <span><?php echo $view['translator']->trans('comment.title', [], 'news_comment'); ?>:</span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table>
                    <thead>
                        <tr>
                            <th><?php echo $view['knp_pagination']->sortable($comments, $view['translator']->trans('comment.table.id', [], 'news_comment'), 'c.id'); ?></th>
                            <th>Author</th>
                            <th><?php echo $view['knp_pagination']->sortable($comments, $view['translator']->trans('comment.table.content', [], 'news_comment'), 'c.content'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($comments, $view['translator']->trans('comment.table.news', [], 'news_comment'), 'n.title'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($comments, $view['translator']->trans('comment.table.created', [], 'news_comment'), 'c.dateCreated'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($comments, $view['translator']->trans('comment.table.status.title', [], 'news_comment'), 'c.status'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($comments as $comment): ?>
                        <tr>
                            <td><?php echo $comment->getId(); ?></td>
                            <td>
                                <?php if (! is_null($comment->getUser())): ?><i class="icon-user"></i><?php else: ?><i class="icon-mail-1"></i><?php endif ?> <?php echo $comment->getName(); ?>
                                <br>
                                <?php if (! is_null($comment->getUser()) && $view['security']->isGranted('ROLE_USERS_INDEX')): ?>
                                    <a href="<?php echo $view['router']->path('wi_admin_users_show', ['id' => $comment->getUser()->getId()]); ?>"><?php echo $comment->getEmail(); ?></a>
                                <?php else: ?>
                                    <a href="mailto:<?php echo $comment->getEmail(); ?>"><?php echo $comment->getEmail(); ?></a>
                                <?php endif ?>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <?php if ($view['security']->isGranted(['ROLE_NEWS_EDIT', 'ROLE_BLOG_EDIT'])): ?>
                                            <a href="<?php echo $view['router']->path('wi_admin_news_comment_edit', ['id' => $comment->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                             / <a href="<?php echo $view['router']->path('wi_admin_news_comment_delete', ['id' => $comment->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo nl2br($comment->getContent()); ?></td>
                            <td><a href="<?php echo $view['router']->path('wi_admin_news_show', ['id' => $comment->getNews()->getId()]); ?>"><?php echo $comment->getNews()->getTitle(); ?></a></td>
                            <td><?php echo $comment->getDateCreated()->format('H:i d.m.Y'); ?></td>
                            <td><?php echo $view['translator']->trans('comment.table.status.options.'.$comment->getStatus(), [], 'news_comment'); ?></td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-6 columns">
            </div>
            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $comments,
                ]); ?>

                <?php echo $view['knp_pagination']->render($comments); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>"></script>
<?php $view['slots']->stop() ?>
