<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.news.newsNew')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.news'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.newsNew'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <i class="icon-newspaper-1"></i><?php echo $view['translator']->trans('news.listTitle'); ?> - <?php echo $view['translator']->trans('newsNew.subTitle'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('newsNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'newsNew' ))); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('newsNew.boxTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.titleTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('newsNew.form.titleDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['title']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['title'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['title'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.shortTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('newsNew.form.shortDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="columns">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['shortcut']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['shortcut']) ? $view['form']->widget($form['shortcut'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['shortcut'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.textTitle'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('newsNew.form.textDesc'); ?></p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="columns">
                                <div class="formAlert <?php echo ($view['form']->errors($form['content']) ? "callout alert" : ""); ?>">
                                    <?php echo $view['form']->errors($form['content']); ?>
                                </div>
                                <div class="formAlert callout alert" id="contentValidation">
                                    <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                                </div>
                                <?php echo $view['form']->widget($form['content']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <hr>
        </div>
    </div>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('newsNew.box2Title'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.movieTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.movieDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['movie']); ?>
                    </div>
                    <?php echo ($view['form']->errors($form['movie']) ? $view['form']->widget($form['movie'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['movie'])); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.catTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.catDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['categories']); ?>
                            </div>
                            <div class="formAlert callout alert hide" id="contentValidationCat">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['categories']) ? $view['form']->widget($form['categories'], array('attr' => array('class' =>'callout alert chosenSelectCategory'))) : $view['form']->widget($form['categories'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.tagTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.tagDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <button class="addTag button tiny secondary" type="button"><span><?php echo $view['translator']->trans('newsNew.form.buttonAddTag'); ?></span></button>
                            <div class="formAddTags hide">
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['tags']); ?>
                                </div>
                                <?php echo $view['form']->label($form['tags']); ?>
                                <?php echo ($view['form']->errors($form['tags']) ? $view['form']->widget($form['tags'], array('attr' => array('class' =>'callout alert chosenSelectCategory'))) : $view['form']->widget($form['tags'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.dateTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.dateDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['dateOfPublication']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['dateOfPublication']) ? $view['form']->widget($form['dateOfPublication'], array('attr' => array('class' =>'callout alert datePicker'))) : $view['form']->widget($form['dateOfPublication'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.status'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsEdit.form.statusDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['status']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['status']) ? $view['form']->widget($form['status'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['status'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-download"></i><span><?php echo $view['translator']->trans('newsNew.enableDownloadTitle'); ?></span></h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.enableDownload.title'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.enableDownload.desc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['enableDownload']); ?>
                    </div>
                    <div>
                        <?php echo $view['form']->widget($form['enableDownload']); ?>
                        <label class="switch-paddle" for="<?php echo $form->children['enableDownload']->vars['id']; ?>">
                            <span class="show-for-sr"></span>
                            <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                            <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('newsNew.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.metaTitle'); ?></strong></p>
                    <p><?php echo $view['translator']->trans('newsNew.form.metaDesc'); ?></p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaTitle']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaTitle']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaTitle']) ? $view['form']->widget($form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaTitle'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaDescription']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaDescription']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaDescription']) ? $view['form']->widget($form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaDescription'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaKeywords']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaKeywords']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaKeywords']) ? $view['form']->widget($form['metaKeywords'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaKeywords'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaCanonical']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaCanonical']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaCanonical']) ? $view['form']->widget($form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaCanonical'])); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaImage']) ?>
                                <div class="formAlert">
                                    <?php echo $view['form']->errors($form['metaImage']); ?>
                                </div>
                                <?php echo ($view['form']->errors($form['metaImage']) ? $view['form']->widget($form['metaImage'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaImage'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box">
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <?php echo $view['form']->widget($form); ?>
                        <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                            <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                        </button>

                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_news_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $view['form']->end($form); ?>


    <div class="box overlay">
        <div class="overlay">
            <div class="text">
                <?php echo $view['translator']->trans('newsNew.form.upload_images_unlock'); ?></div>
        </div>
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-picture"></i> <span><?php echo $view['translator']->trans('newsNew.form.images'); ?></span>
            </h3>
        </div>
        <div class="box-body " style="display: block;">
            <div id="image-upload-box">
                <img id="cropperPreview" class="previewImage thumbnail"  src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="" data-open="windowModalCropper">
                <label class="AddImage" for="appbundle_photo_file" >
                    <input type="file" id="appbundle_photo_file" class="InputFileHidden">
                    <span class="button" id="imageDataFromParameter" type="button" cropper-width="<?php echo $view['config']->get('news.imageWidth'); ?>" cropper-height="<?php echo $view['config']->get('news.imageHeight'); ?>">
                        <i class="icon-upload"></i><?php echo $view['translator']->trans('newsNew.form.addImage'); ?>
                    </span>
                </label>
            </div>
        </div>
    </div>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js') ?>"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
