<?php

namespace Wi\Admin\NewsBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Wi\Admin\CoreBundle\Utils\Upload;

/**
 * Upload photos for News.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UploadBlogPhoto extends Upload
{
    /**
     * Construct.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // Called to parent construct.
        parent::__construct($container);

        // Get config.
        $config = $container->get('config');

        // Set news image config.
        $this->config = [
            '' => [
                'width' => (int) $config->get('blog.imageWidth'),
                'height' => (int) $config->get('blog.imageHeight'),
            ],
            'thumbnail' => [
                'width' => (int) $config->get('blog.thumbnailWidth'),
                'height' => (int) $config->get('blog.thumbnailHeight'),
            ],
            'thumbnailS' => [
                'width' => (int) $config->get('blog.thumbnailSWidth'),
                'height' => (int) $config->get('blog.thumbnailSHeight'),
            ],
        ];

        // Set a directory.
        $this->dir = $this->container->getParameter('assets_dirs.blog');
    }
}
