<?php

namespace Wi\Admin\NewsBundle\Utils;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Wi\Admin\CoreBundle\Utils\Upload;

/**
 * Upload photos for News.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class UploadNewsPhoto extends Upload
{
    /**
     * Construct.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        // Called to parent construct.
        parent::__construct($container);

        // Get config.
        $config = $container->get('config');

        // Set news image config.
        $this->config = [
            '' => [
                'width' => (int) $config->get('news.imageWidth'),
                'height' => (int) $config->get('news.imageHeight'),
            ],
            'thumbnail' => [
                'width' => (int) $config->get('news.thumbnailWidth'),
                'height' => (int) $config->get('news.thumbnailHeight'),
            ],
            'thumbnailS' => [
                'width' => (int) $config->get('news.thumbnailSWidth'),
                'height' => (int) $config->get('news.thumbnailSHeight'),
            ],
        ];

        // Set a directory.
        $this->dir = $this->container->getParameter('assets_dirs.news');
    }
}
