<?php

namespace Wi\Admin\NewsLetterBundle\Command\SQL;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DropViewCommand extends ContainerAwareCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('app:doctrine:newsletter:drop-view')
            ->setDescription('Usun widok SQL dla modulu Newsletter.')
            ->setHelp('Usuwa widok SQL dla modulu Newsletter wykorzytywany dla statystyk.')
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $output->writeln('Usuwanie widoku SQL dla statystyk Newslettera.');
        $em = $this->getContainer()->get('doctrine.orm.entity_manager');
        $conn = $em->getConnection();
        $statsPerDayTable = $em->getClassMetadata('WiAdminNewsLetterBundle:ViewNewsletterStatsPerDay')->getTableName();
        $statsPerHourTable = $em->getClassMetadata('WiAdminNewsLetterBundle:ViewNewsletterStatsPerHour')->getTableName();

        $sql = "DROP TABLE IF EXISTS $statsPerDayTable";
        $stmt = $conn->prepare($sql);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunieto tabele: <info>' . $statsPerDayTable . '</info>');
        }

        $sql = "DROP TABLE IF EXISTS $statsPerHourTable";
        $stmt = $conn->prepare($sql);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunieto tabele: <info>' . $statsPerHourTable . '</info>');
        }

        $sqlView = "DROP VIEW IF EXISTS `$statsPerDayTable`";
        $stmt = $conn->prepare($sqlView);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunięto widok: <info>' . $statsPerDayTable . '</info>');
        }

        $sqlView = "DROP VIEW IF EXISTS `$statsPerHourTable`";
        $stmt = $conn->prepare($sqlView);
        $res = $stmt->execute();

        if ($res) {
            $output->writeln('Usunięto widok: <info>' . $statsPerHourTable . '</info>');
        }
    }
}
