<?php

namespace Wi\Admin\NewsLetterBundle\Controller;

use Wi\Admin\NewsLetterBundle\Entity\Logs;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

/**
 * Log controller.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LogsController extends Controller
{
    /**
     * Lists all log entities.
     *
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $logs = $em->getRepository('WiAdminNewsLetterBundle:Logs')->findAll();

        return $this->render('WiAdminNewsLetterBundle:Logs:index.html.php', array(
            'logs' => $logs,
        ));
    }

    /**
     * Creates a new log entity.
     *
     */
    public function newAction(Request $request)
    {
        $log = new Log();
        $form = $this->createForm('Wi\Admin\NewsLetterBundle\Form\LogsType', $log);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($log);
            $em->flush();

            return $this->redirectToRoute('logs_show', array('id' => $log->getId()));
        }

        return $this->render('WiAdminNewsLetterBundle:Logs:new.html.php', array(
            'log' => $log,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a log entity.
     *
     */
    public function showAction(Logs $log)
    {

        return $this->render('WiAdminNewsLetterBundle:Logs:show.html.php', array(
            'log' => $log,
        ));
    }

    /**
     * Displays a form to edit an existing log entity.
     *
     */
    public function editAction(Request $request, Logs $log)
    {
        $deleteForm = $this->createDeleteForm($log);
        $editForm = $this->createForm('Wi\Admin\NewsLetterBundle\Form\LogsType', $log);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('logs_edit', array('id' => $log->getId()));
        }

        return $this->render('WiAdminNewsLetterBundle:Logs:edit.html.php', array(
            'log' => $log,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a log entity.
     *
     */
    public function deleteAction(Request $request, Logs $log)
    {
        $form = $this->createDeleteForm($log);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($log);
            $em->flush();
        }

        return $this->redirectToRoute('logs_index');
    }

    /**
     * Creates a form to delete a log entity.
     *
     * @param Logs $log The log entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Logs $log)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('logs_delete', array('id' => $log->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
