<?php

namespace Wi\Admin\NewsLetterBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Wi\Admin\NewsBundle\Entity\News;
use Wi\Admin\NewsLetterBundle\Entity\MessageContent;
use Wi\Admin\NewsLetterBundle\Form\MessageContentType;
use Wi\Admin\NewsLetterBundle\Form\MessageContentDeleteType;

/**
 * Messagecontent controller.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class MessageContentController extends Controller
{
    /**
     * Lists all messageContent entities.
     *
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $messageContent = $em->getRepository('WiAdminNewsLetterBundle:MessageContent')->findAll();

        return $this->render('WiAdminNewsLetterBundle:MessageContent:index.html.php', array(
            'messageContent' => $messageContent,
        ));
    }

    /**
     * Creates a new messageContent entity.
     *
     */
    public function newAction(Request $request)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();

        // Utworzenie nowego obiektu pytań.
        $messageContent = new MessageContent();

        // Dodanie domyślnej kategorii, jeśli została przekazana oraz istnieje.
        if ($request->query->getInt('id')) {
            $campaign = $em->getRepository('WiAdminNewsLetterBundle:Campaign')
                ->findOneById($request->query->getInt('id'))
            ;

            if (! is_null($campaign)) {
                $messageContent->setCampaign($campaign);
            }
        }

        // Generowanie formularza.
        $form = $this->createForm(MessageContentType::class, $messageContent);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Zapis.
            $em->persist($messageContent);
            $em->flush();

            return $this->redirectToRoute('wi_admin_newsletter_mainsite_index');
        }

        return $this->render('WiAdminNewsLetterBundle:MessageContent:new.html.php', [
            'form' => $form->createView(),
            'messageContent' => $messageContent,
        ]);
    }

    /**
     * Finds and displays a messageContent entity.
     *
     */
    public function showAction(MessageContent $messageContent)
    {
        return $this->render('WiAdminNewsLetterBundle:MessageContent:show.html.php', array(
            'messageContent' => $messageContent,
        ));
    }

    /**
     * Displays a form to edit an existing messageContent entity.
     *
     */
    public function editAction(Request $request, MessageContent $messageContent)
    {
        // Generowanie formularza.
        $form = $this->createForm(MessageContentType::class, $messageContent);
        $form->handleRequest($request);

        // Weryfikacja, czy formularz został przesłany i pomyślnie zwalidowany.
        if ($form->isSubmitted() && $form->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Zapis.
            $em->persist($messageContent);
            $em->flush();

            return $this->redirectToRoute('wi_admin_newsletter_mainsite_index');
        }

        return $this->render('WiAdminNewsLetterBundle:MessageContent:edit.html.php', [
            'form' => $form->createView(),
            'messageContent' => $messageContent,
        ]);
    }

    /**
     * Deletes a messageContent entity.
     *
     */
    public function deleteAction(Request $request, MessageContent $messageContent)
    {
        // Generowanie formularza.
        $deleteForm = $this->createForm(MessageContentDeleteType::class);
        $deleteForm->handleRequest($request);

        // Weryfikacja czy formularz został przesłany i pomyślnie zwalidowany.
        if ($deleteForm->isSubmitted() && $deleteForm->isValid()) {
            // Utworzenie instancji EntityManager-a.
            $em = $this->getDoctrine()->getManager();

            // Usunięcie.
            $em->remove($messageContent);
            $em->flush();

            return $this->redirectToRoute('wi_admin_newsletter_mainsite_index');
        }

        return $this->render('WiAdminNewsLetterBundle:MessageContent:delete.html.php', [
            'deleteForm' => $deleteForm->createView(),
            'messageContent' => $messageContent,
        ]);
    }

    public function saveNewsAsMessageAction(Request $request, News $news)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $this->getDoctrine()->getManager();
        $template_type = $request->request->get('template_type');
        $campaign = $em->getRepository('WiAdminNewsLetterBundle:Campaign')
            ->find($request->request->getInt('campaign_id'))
        ;
        $message = new MessageContent();
        $message
            ->setCampaign($campaign)
            ->setTitle($news->getTitle())
            ->setStatus(MessageContent::STATUS_INACTIVE)
        ;

        switch ($template_type) {
            case 'full':
                $content = $news->getContent();
                break;
            default:
                $content = $news->getShortcut();
                break;
        }

        $message->setMessage($this->render('WiAdminNewsLetterBundle:MessageContent:Emails/news_template.html.php', [
            'content' => $content,
            'news' => $news,
        ])->getContent());

        $em->persist($message);
        $em->flush($message);

        return $this->redirectToRoute('wi_admin_newsletter_messagecontent_edit', [
            'id' => $message->getId()
        ]);
    }
}
