<?php

namespace Wi\Admin\NewsLetterBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;

/**
 * CampaignConfig
 *
 * @ORM\Table(name="newsletter_campaignConfigs")
 * @ORM\Entity(repositoryClass="Wi\Admin\NewsLetterBundle\Repository\CampaignConfigRepository")
 * @ORM\HasLifecycleCallbacks()
 * @Gedmo\SoftDeleteable(fieldName = "dateDeleted")
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CampaignConfig
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Wi\Admin\NewsLetterBundle\Entity\Campaign
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\NewsLetterBundle\Entity\Campaign", inversedBy="config")
     * @ORM\JoinColumn(name="campaign_id", referencedColumnName="id", nullable=false)
     */
    private $campaign;

    /**
     * @var string
     *
     * @ORM\Column(name="paramName", type="string", length=45)
     */
    private $paramName;

    /**
     * @var string
     *
     * @ORM\Column(name="paramValue", type="string", length=255, nullable=true)
     */
    private $paramValue;

    /**
     * @var string
     *
     * @ORM\Column(name="aidValue", type="string", length=255, nullable=true)
     */
    private $aidValue;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateDeleted", type="datetime", nullable=true)
     */
    private $dateDeleted;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set campaign
     *
     * @param Campaign $campaign
     * @return CampaignConfig
     */
    public function setCampaign(Campaign $campaign)
    {
        $this->campaign = $campaign;

        return $this;
    }

    /**
     * Get campaign
     *
     * @return Campaign
     */
    public function getCampaign()
    {
        return $this->campaign;
    }

    /**
     * Set paramName
     *
     * @param string $paramName
     * @return CampaignConfig
     */
    public function setParamName($paramName)
    {
        $this->paramName = $paramName;

        return $this;
    }

    /**
     * Get paramName
     *
     * @return string
     */
    public function getParamName()
    {
        return $this->paramName;
    }

    /**
     * Set paramValue
     *
     * @param string $paramValue
     * @return CampaignConfig
     */
    public function setParamValue($paramValue)
    {
        $this->paramValue = $paramValue;

        return $this;
    }

    /**
     * Get paramValue
     *
     * @return string
     */
    public function getParamValue()
    {
        return $this->paramValue;
    }

    /**
     * Set aidValue
     *
     * @param string $aidValue
     * @return CampaignConfig
     */
    public function setAidValue($aidValue)
    {
        $this->aidValue = $aidValue;

        return $this;
    }

    /**
     * Get aidValue
     *
     * @return string
     */
    public function getAidValue()
    {
        return $this->aidValue;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return CampaignConfig
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set dateDeleted
     *
     * @param \DateTime $dateDeleted
     * @return CampaignConfig
     */
    public function setDateDeleted($dateDeleted)
    {
        $this->dateDeleted = $dateDeleted;

        return $this;
    }

    /**
     * Get dateDeleted
     *
     * @return \DateTime
     */
    public function getDateDeleted()
    {
        return $this->dateDeleted;
    }
}
