<?php

namespace Wi\Admin\NewsLetterBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;
use Wi\Admin\NewsLetterBundle\Entity\MessageContent;
use Wi\Admin\NewsLetterBundle\Entity\Recipients;
use Wi\Admin\NewsLetterBundle\Entity\Senders;

/**
 * Logs
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="newsletter_logs")
 * @ORM\Entity(repositoryClass="Wi\Admin\NewsLetterBundle\Repository\LogsRepository")
 * @ORM\HasLifecycleCallbacks()
 */
class Logs
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_message", type="datetime", nullable=true)
     */
    private $dateMessage;

    /**
     * @var Wi\Admin\NewsLetterBundle\Entity\Recipients
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\NewsLetterBundle\Entity\Recipients", fetch="EAGER")
     * @ORM\JoinColumn(name="recipient_id", referencedColumnName="id")
     */
    private $recipient;

    /**
     * @var Wi\Admin\NewsLetterBundle\Entity\Senders
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\NewsLetterBundle\Entity\Senders", fetch="EAGER")
     * @ORM\JoinColumn(name="sender_id", referencedColumnName="id")
     */
    private $sender;

    /**
     * @var Wi\Admin\NewsLetterBundle\Entity\Campaign
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\NewsLetterBundle\Entity\Campaign", inversedBy="logs", fetch="EAGER")
     * @ORM\JoinColumn(name="campaign_id", referencedColumnName="id")
     */
    private $campaign;

    /**
     * @var Wi\Admin\NewsLetterBundle\Entity\MessageContent
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\NewsLetterBundle\Entity\MessageContent", fetch="EAGER")
     * @ORM\JoinColumn(name="message_content_id", referencedColumnName="id")
     */
    private $messageContent;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie statusu.
        if (is_null($this->status)) {
            $this->status = 'A';
        }

        $this->dateMessage = new \DateTime();
    }

    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dateMessage
     *
     * @param \DateTime $dateMessage
     * @return Logs
     */
    public function setDateMessage($dateMessage)
    {
        $this->dateMessage = $dateMessage;

        return $this;
    }

    /**
     * Get dateMessage
     *
     * @return \DateTime
     */
    public function getDateMessage()
    {
        return $this->dateMessage;
    }

    /**
     * Set recipient
     *
     * @param Recipients $recipient
     * @return Logs
     */
    public function setRecipient($recipient)
    {
        $this->recipient = $recipient;

        return $this;
    }

    /**
     * Get recipient
     *
     * @return Recipients
     */
    public function getRecipient()
    {
        return $this->recipient;
    }

    /**
     * Set sender
     *
     * @param Senders $sender
     * @return Logs
     */
    public function setSender($sender)
    {
        $this->sender = $sender;

        return $this;
    }

    /**
     * Get sender
     *
     * @return Senders
     */
    public function getSender()
    {
        return $this->sender;
    }

    /**
     * Set campaign
     *
     * @param Campaign $campaign
     * @return Logs
     */
    public function setCampaign($campaign)
    {
        $this->campaign = $campaign;

        return $this;
    }

    /**
     * Get campaign
     *
     * @return Campaign
     */
    public function getCampaign()
    {
        return $this->campaign;
    }

    /**
     * Set messageContent
     *
     * @param MessageContent $messageContent
     * @return Logs
     */
    public function setMessageContent($messageContent)
    {
        $this->messageContent = $messageContent;

        return $this;
    }

    /**
     * Get messageContent
     *
     * @return MessageContent
     */
    public function getMessageContent()
    {
        return $this->messageContent;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Logs
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set note
     *
     * @param string $note
     * @return Logs
     */
    public function setNote($note)
    {
        $this->note = $note;

        return $this;
    }

    /**
     * Get note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->note;
    }
}
