<?php

namespace Wi\Admin\NewsLetterBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\Validator\Constraints as Assert;
use Wi\Admin\NewsLetterBundle\Entity\RecipientGroup;

/**
 * Recipients
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(name="newsletter_recipients")
 * @ORM\Entity(repositoryClass="Wi\Admin\NewsLetterBundle\Repository\RecipientsRepository")
 * @ORM\EntityListeners({"Wi\Admin\NewsLetterBundle\EventListener\Entity\RecipientsListener"})
 * @ORM\HasLifecycleCallbacks()
 * @Gedmo\SoftDeleteable(fieldName = "dateDeleted")
 */
class Recipients
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var Wi\Admin\NewsLetterBundle\Entity\RecipientGroup
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\NewsLetterBundle\Entity\RecipientGroup", inversedBy="recipients")
     * @ORM\JoinColumn(name="recipientGroup_id", referencedColumnName="id", nullable=false)
     */
    private $recipientGroup;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=64)
     * @Assert\NotBlank()
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=45, nullable=true, unique=false)
     */
    private $name;

    /**
     * @var int
     *
     * @ORM\Column(name="consent", type="integer", options={"default": "1", "fixed" = true})
     */
    private $consent;

    /**
     * @var string
     *
     * @ORM\Column(name="hash", type="string", length=128, nullable=true)
     */
    private $hash;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_deleted", type="datetime", nullable=true)
     */
    private $dateDeleted;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=1, options={"default": "A", "fixed" = true})
     */
    private $status;


    // ------------------------------------------------------------
    // Has Lifecycle Callbacks methods.
    // ------------------------------------------------------------

    /**
     * Funkcja wykonuje się podczas wstawiania nowego rekordu do bazy.
     *
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        // Ustawienie daty utworzenia.
        $this->dateCreated = new \DateTime();

        // Ustawienie statusu.
        $this->status = 'A';

        if (is_null($this->consent)) {
            $this->consent = 1;
        }
    }

     // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set recipientGroup
     *
     * @param RecipientGroup $recipientGroup
     * @return Recipients
     */
    public function setRecipientGroup(RecipientGroup $recipientGroup)
    {
        $this->recipientGroup = $recipientGroup;

        return $this;
    }

    /**
     * Get recipientGroup
     *
     * @return RecipientGroup
     */
    public function getRecipientGroup()
    {
        return $this->recipientGroup;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return Recipients
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Recipients
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set consent
     *
     * @param int $consent
     * @return Recipients
     */
    public function setConsent($consent)
    {
        $this->consent = $consent;

        return $this;
    }

    /**
     * Get consent
     *
     * @return int
     */
    public function getConsent()
    {
        return $this->consent;
    }

    /**
     * Set hash
     *
     * @param string $hash
     * @return User
     */
    public function setHash($hash)
    {
        $this->hash = $hash;

        return $this;
    }

    /**
     * Get hash
     *
     * @return string
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     * @return Recipients
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set dateDeleted
     *
     * @param \DateTime $dateDeleted
     * @return Recipients
     */
    public function setDateDeleted($dateDeleted)
    {
        $this->dateDeleted = $dateDeleted;

        return $this;
    }

    /**
     * Get dateDeleted
     *
     * @return \DateTime
     */
    public function getDateDeleted()
    {
        return $this->dateDeleted;
    }

    /**
     * Set status
     *
     * @param string $status
     * @return Recipients
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->logs = new ArrayCollection();
    }

    // ------------------------------------------------------------
    // Deprecations.
    // ------------------------------------------------------------

    /**
     * Set lang
     *
     * @param string $lang
     * @return Recipients
     */
    public function setLang($lang)
    {
        $this->lang = $lang;

        return $this;
    }

    /**
     * Get lang
     *
     * @return string
     */
    public function getLang()
    {
        return;
    }
}
