<?php

namespace Wi\Admin\NewsLetterBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ViewNewsletterStatsPerDay
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Entity(repositoryClass="Wi\Admin\NewsLetterBundle\Repository\ViewNewsletterStatsPerDayRepository", readOnly=true)
 * @ORM\Table(name="view_newsletter_stats_per_days")
 */
class ViewNewsletterStatsPerDay
{
    /**
     * @var string
     *
     * @ORM\Column(name="campaign_id")
     * @ORM\Id
     */
    private $campaignId;

    /**
     * @var string
     *
     * @ORM\Column(name="date")
     * @ORM\Id
     */
    private $date;

    /**
     * @var string
     *
     * @ORM\Column(name="messages")
     */
    private $messages;


    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get campaign id
     *
     * @return int
     */
    public function getCampaignId()
    {
        return $this->campaignId;
    }

    /**
     * Get date
     *
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * Get messages
     *
     * @return string
     */
    public function getMessages()
    {
        return $this->messages;
    }

    // ------------------------------------------------------------
    // Methods.
    // ------------------------------------------------------------

    /**
     * Constructor.
     */
    private function __construct()
    {
    }
}
