<?php

namespace Wi\Admin\NewsLetterBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;

/**
 * Campaign Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class CampaignListener
{
    /**
     * Metoda jest wykonywana przed usunięciem pytania.
     *
     * @param  Campaign           $campaign
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(Campaign $campaign, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $campaign->setStatus('D');

        // Zapis.
        $em->persist($campaign);
        $em->flush();
    }
}
