<?php

namespace Wi\Admin\NewsLetterBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\NewsLetterBundle\Entity\MessageContent;

/**
 * MessageContent Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class MessageContentListener
{
  /**
     * Metoda jest wykonywana przed usunięciem pytania.
     *
     * @param  MessageContent       $messageContent
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(MessageContent $messageContent, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $messageContent->setStatus('D');

        // Zapis.
        $em->persist($messageContent);
        $em->flush();
    }
}
