<?php

namespace Wi\Admin\NewsLetterBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\NewsLetterBundle\Entity\Recipients;

/**
 * Recipients Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class RecipientsListener
{
    /**
     * Metoda jest wykonywana przed usunięciem pytania.
     *
     * @param  Recipients           $recipients
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(Recipients $recipients, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $recipients->setStatus('D');

        // Zapis.
        $em->persist($recipients);
        $em->flush();
    }
}
