<?php

namespace Wi\Admin\NewsLetterBundle\EventListener\Entity;

use Doctrine\ORM\Event\LifecycleEventArgs;
use Wi\Admin\NewsLetterBundle\Entity\Senders;

/**
 * Sender Listener.
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class SendersListener
{
  /**
     * Metoda jest wykonywana przed usunięciem pytania.
     *
     * @param  Senders              $sender
     * @param  LifecycleEventArgs   $event
     */
    public function preRemove(Senders $sender, LifecycleEventArgs $event)
    {
        // Utworzenie instancji EntityManager-a.
        $em = $event->getObjectManager();

        // Ustawienie statusu na usunięty.
        $sender->setStatus('D');

        // Zapis.
        $em->persist($sender);
        $em->flush();
    }
}
