<?php

namespace Wi\Admin\NewsLetterBundle\Form;

use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;

class CampaignType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'attr' => [
                    'class' => '',
                    'maxlength' => 128,
                ],
                'required' => false,
            ])
            ->add('dateExpired', DateTimeType::class, [
                'attr' => [
                    'class' => 'datePicker',
                ],
                'format' => 'dd-MM-yyyy',
                'required' => false,
                'widget' => 'single_text',
            ])
            ->add('senders', EntityType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'choice_label' => 'name',
                'class' => 'WiAdminNewsLetterBundle:Senders',
                'multiple' => true,
                'required' => false,
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('s')
                        ->orderBy('s.name', 'ASC')
                    ;
                },
            ])
            ->add('recipientGroups', EntityType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'choice_label' => 'name',
                'class' => 'WiAdminNewsLetterBundle:RecipientGroup',
                'multiple' => true,
                'required' => false,
                'query_builder' => function (EntityRepository $er) {
                    return $er->createQueryBuilder('rg')
                        ->orderBy('rg.name', 'ASC')
                    ;
                },
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Campaign::class
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_newsletterbundle_campaign';
    }
}
