<?php

namespace Wi\Admin\NewsLetterBundle\Form;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Wi\Admin\NewsLetterBundle\Entity\MessageContent;
//use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

/**
 * MessageContent Type
 *
 * @author Maksymilian Baryczka <mmaxioo33@gmail.com>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class MessageContentType extends AbstractType
{
    /**
     * @var EntityManagerInterface
     */
    private $em;

    /**
     * Construct.
     *
     * @param EntityManagerInterface $em
     */
    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, [
                'attr' => [
                    'maxlength' => 128,
                ],
            ])
            ->add('message', TextareaType::class, [
                'attr' => [
                    'class' => 'tinyMCE',
                    'maxlength' => 65535,
                    'rows' => 10,
                ],
                'label' => 'message',
                'required' => false,
            ])
            ->add('campaign', ChoiceType::class, [
                'attr' => [
                    'class' => 'chosenSelectCampaign',
                ],
                'choice_label' => function ($value, $key, $index) {
                    return $value->label;
                },
                'choice_translation_domain' => false,
                'choices' => $this->getChoices(),
                'required' => true,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => MessageContent::class,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_newsletter_messagecontent';
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Przetwarza grupy stron i generuje z nich drzewo.
     *
     * @return PageGroup[]
     */
    private function getChoices()
    {
        $choices = [];

        // Pobranie wszystkich głównych, aktywnych grup stron.
        $campaign = $this->em->getRepository('WiAdminNewsLetterBundle:Campaign')
            ->findAll()
        ;


        foreach ($campaign as $campaignS) {
                // Pole label jest tworzone dynamicznie tylko na potrzeby wypisania etykiety.
                $campaignS->label = $campaignS->getName();
                $choices[] = $campaignS;
            }


        return $choices;
    }
}
