<?php

namespace Wi\Admin\NewsLetterBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class RecipientsType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('email', TextType::class, [
                'attr' => [
                    'maxlength' => 64,
                ],
            ])
            ->add('name', TextType::class, [
                'attr' => [
                    'maxlength' => 45,
                ],
                'required' => false,
            ])
            ->add('lang', TextType::class, [
                'attr' => [
                    'maxlength' => 2,
                ],
                'required' => false,
            ])
            ->add('consent', ChoiceType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'choices' => [
                    'Lack of consent' => '0',
                    'Consent approved' => '1', 
                ],
                'label' => 'blockNew.form.typeTitle',
                'required' => true,
            ])
            ->add('status', ChoiceType::class, [
                'attr' => [
                    'class' => 'chosenSelect',
                ],
                'choices' => [
                    'Active' => 'A',
                    'Blocked' => 'B',
                    'Undelivery' => 'U',
                ],
                'label' => 'blockNew.form.typeTitle',
                'required' => true,
            ])
        ;
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Wi\Admin\NewsLetterBundle\Entity\Recipients'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_newsletterbundle_recipients';
    }


}
