<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ConfigRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ConfigRepository extends EntityRepository
{
    const PARAM_BCC_NAME = 'bcc';
    const PARAM_CURRENT_CAMPAIGN_NAME = 'current_campaign';
    const PARAM_DATE_END_NAME = 'date_end';
    const PARAM_DATE_START_NAME = 'date_start';
    const PARAM_DAYS_OF_WEEK_NAME = 'days_of_week';
    const PARAM_ENABLE_NEWSLETTER_NAME = 'enable_newsletter';
    const PARAM_TIME_END_NAME = 'time_end';
    const PARAM_TIME_START_NAME = 'time_start';
    const PARAM_QUANTITY_TO_SENT_NAME = 'quantity_to_sent';
    const PARAM_RANDOMIZE_MESSAGES_NAME = 'randomize_messages';
    const PARAM_RANDOMIZE_RECIPIENTS_NAME = 'randomize_recipients';
    const PARAM_RANDOMIZE_SENDERS_NAME = 'randomize_senders';

    /**
     * Pobranie parametru na podstawie jego nazwy.
     *
     * @param string $paramName
     * @return Config|null
     */
    public function getCurrentConfigByParamName($paramName)
    {
        return $this->createQueryBuilder('c')
            ->where('c.paramName = :paramName')
            ->andWhere('c.dateDeleted IS NULL')
            ->setParameters([
                'paramName' => $paramName,
            ])
            ->orderBy('c.id', 'DESC')
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }

    /**
     * Pobiera stan (ON/OFF) newslettera.
     *
     * @return \Wi\Admin\NewsLetterBundle\Entity\Config
     */
    public function getEnableNewsletter()
    {
        return $this->getCurrentConfigByParamName(self::PARAM_ENABLE_NEWSLETTER_NAME);
    }

    /**
     * Pobranie akutalnej konfiguracji.
     *
     * @return array
     */
    public function getConfig()
    {
        return [
            // 'bcc' => $this->getBcc(),
            // 'current_campaign' => $this->getCurrentCampaign(),
            // 'date_end' => $this->isDateEndNonExpired(),
            // 'days_of_week' => $this->isActivatedDaysOfWeek(),
            // 'date_start' => $this->isDateStartNonExpired(),
            'enable_newsletter' => $this->isEnabledNewsletter(),
            // 'time_end' => $this->isActiveHourEnd(),
            // 'time_start' => $this->isActiveHourStart(),
            // 'quantity_to_sent' => $this->getQuantityToSent(),
            // 'randomize_messages' => $this->isRandomizeMessages(),
            // 'randomize_recipients' => $this->isRandomizeRecipients(),
            // 'randomize_senders' => $this->isRandomizeSenders(),
        ];
    }

    /**
     * Pobranie informacji na temat BCC.
     *
     * @return string|bool
     */
    public function getBcc()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_BCC_NAME))
            ? false
            : (filter_var($result->getParamValue(), FILTER_VALIDATE_EMAIL) ? $result->getParamValue() : false)
        );
    }

    /**
     * Pobiera informację, czy ustawiona jest kampania.
     *
     * @return bool|int
     */
    public function getCurrentCampaign()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_CURRENT_CAMPAIGN_NAME))
            ? false
            : intval($result->getParamValue())
        );
    }

    /**
     * Pobiera liczbę wiadomości do jednorazowego wysłania.
     *
     * @return int
     */
    public function getQuantityToSent()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_QUANTITY_TO_SENT_NAME))
            ? 0
            : intval($result->getParamValue())
        );
    }

    /**
     * Pobiera informację o aktywnych dniach tygodnia.
     *
     * @return bool
     */
    public function isActivatedDaysOfWeek()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_DAYS_OF_WEEK_NAME))
            ? false
            : (in_array(date('N'), explode(',', $result->getParamValue())))
        );
    }

    /**
     * Pobiera informację, czy godzina rozpoczęcia newslettera jest aktywna.
     *
     * @return bool
     */
    public function isActiveHourStart()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_TIME_START_NAME))
            ? false
            : (date('H:i') >= $result->getParamValue())
        );
    }

    /**
     * Pobiera informację, czy godzina zakończenia newslettera jest aktywna.
     *
     * @return bool
     */
    public function isActiveHourEnd()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_TIME_END_NAME))
            ? false
            : (date('H:i') <= $result->getParamValue())
        );
    }

    /**
     * Pobiera informację, czy data zakończenia jeszce nie nadeszła.
     *
     * @return bool
     */
    public function isDateEndNonExpired()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_DATE_END_NAME))
            ? false
            : ($result->getParamValue() >= date('Y-m-d'))
        );
    }

    /**
     * Pobiera informację, czy data rozpoczęcia została już osiągnięta
     *
     * @return bool
     */
    public function isDateStartNonExpired()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_DATE_START_NAME))
            ? false
            : ($result->getParamValue() <= date('Y-m-d'))
        );
    }

    /**
     * Pobiera informację, czy newsletter jest włączony lub wyłączony.
     *
     * @return bool
     */
    public function isEnabledNewsletter()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_ENABLE_NEWSLETTER_NAME))
            ? false
            : boolval(intval($result->getParamValue()))
        );
    }

    /**
     * Czy wiadomości mają być wybierane losowo.
     *
     * @return bool
     */
    public function isRandomizeMessages()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_RANDOMIZE_MESSAGES_NAME))
            ? false
            : boolval(intval($result->getParamValue()))
        );
    }

    /**
     * Czy odbiorcy mają być wybierani losowo.
     *
     * @return bool
     */
    public function isRandomizeRecipients()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_RANDOMIZE_RECIPIENTS_NAME))
            ? false
            : boolval(intval($result->getParamValue()))
        );
    }

    /**
     * Czy nadawcy mają być wybierani losowo.
     *
     * @return bool
     */
    public function isRandomizeSenders()
    {
        return (
            is_null($result = $this->getCurrentConfigByParamName(self::PARAM_RANDOMIZE_SENDERS_NAME))
            ? false
            : boolval(intval($result->getParamValue()))
        );
    }
}
