<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Wi\Admin\NewsLetterBundle\Entity\MessageContent;
use Wi\Admin\NewsLetterBundle\Entity\Senders;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;

/**
 * LogsRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class LogsRepository extends EntityRepository
{
    public function countByMessageContent(MessageContent $messageContent, Campaign $campaign = null)
    {
        $qb = $this->createQueryBuilder('l')
            ->where('l.status = :status')
            ->andWhere('l.messageContent = :messageContent')
        ;

        $params = [
            'messageContent' => $messageContent,
            'status' => 'A',
        ];

        if (! is_null($campaign)) {
            $params['campaign'] = $campaign;
            $qb->andWhere('l.campaign = :campaign');
        }

        return (int) $qb
            ->select($qb->expr()->count('l'))
            ->setParameters($params)
            ->getQuery()
            ->getSingleScalarResult()
        ;
    }

    public function countBySender(Senders $sender, Campaign $campaign = null)
    {
        $qb = $this->createQueryBuilder('l')
            ->where('l.status = :status')
            ->andWhere('l.sender = :sender')
        ;

        $params = [
            'sender' => $sender,
            'status' => 'A',
        ];

        if (! is_null($campaign)) {
            $params['campaign'] = $campaign;
            $qb->andWhere('l.campaign = :campaign');
        }

        return (int) $qb
            ->select($qb->expr()->count('l'))
            ->setParameters($params)
            ->getQuery()
            ->getSingleScalarResult()
        ;
    }

    /**
     * Pobiera zapytanie dla wszystkich aktywnych aktualności.
     *
     * @param int $campaign_id ID kampanii do filtrowania logów.
     * @param datetime $date_message data logu do filtrowania logów.
     * @param string $search
     * @return array
     */
    public function getFindAllActiveQuery($campaign_id = null, $date_message = null)
    {
        // Utworzenie QueryBuilder'a.
        $qb =  $this->createQueryBuilder('l')
            ->leftJoin('l.campaign', 'c')
            ->where('l.status = :status')
        ;

        // Ustawienie parametrów dla zapytania.
        $params = [
            'status' => 'A',
        ];

        // Jeśli ID kampanii zostało przekazane to zawęźić do tej kategorii.
        if ($campaign_id) {
            $params['campaign_id'] = $campaign_id;
            $qb->andWhere('c.id = :campaign_id');
        }

        // Jeśli data logu została przekazana to zawęźić do tej daty.
        if ($date_message) {
            $params['date_message'] = $date_message;
            $qb->andWhere('l.date_message = :date_message');
        }

        return $qb
            ->setParameters($params)
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobranie logów dla podanej kampanii.
     *
     * @param int $category_id
     * @return Query
     */
    public function getLogsByCampaign($campaign_id = null)
    {
        // Utworzenie QueryBuilder'a.
        $qb =  $this->createQueryBuilder('l')
            ->innerJoin('l.campaign', 'lc')
            ->where('lc.id = :campaign_id')
        ;

        $params = [
            'campaign_id' => $campaign_id,
        ];

        return $qb
            ->setParameters($params)
            ->getQuery()
        ;
    }
}
