<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

use Wi\Admin\NewsLetterBundle\Entity\Campaign;

/**
 * MessageContentRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class MessageContentRepository extends \Doctrine\ORM\EntityRepository
{
    /**
     * Pobiera wszystkie aktywne pytania.
     *
     * @return array
     */
    public function findAllActive()
    {
        return $this->createQueryBuilder('q')
            ->where('q.status = :status')
            ->andWhere('q.dateDeleted IS NULL')
            ->setParameters([
                'status' => 'A',
            ])
            ->orderBy('q.title', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
     * Pobranie treści wiadomości na podstawie kampani. Jeśli jest
     * wybrana opcja losowa, to zwraca losową treść wiadomości.
     *
     * @param Campaign $campaign
     * @param bool $random
     * @return MessageContent|null
     */
    public function findMessageContentByCampaing(Campaign $campaign, $random = false)
    {
        $qb = $this->createQueryBuilder('s')
            ->where('s.status = :status')
            ->andWhere('s.campaign = :campaign')
        ;

        if ($random) {
            $qb->orderBy('RAND()');
        }

        return $qb
            ->setParameters([
                'campaign' => $campaign,
                'status' => 'A',
            ])
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
