<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\ResultSetMapping;
use Wi\Admin\NewsLetterBundle\Entity\Campaign;
use Wi\Admin\NewsLetterBundle\Entity\RecipientGroup;
use Wi\Admin\NewsLetterBundle\Entity\Recipients;

/**
 * RecipientsRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class RecipientsRepository extends EntityRepository
{
    /**
     * Pobiera wszystkie aktywne pytania.
     *
     * @return array
     */
    public function findAllActive()
    {
        return new ArrayCollection(
            $this->createQueryBuilder('q')
                ->where('q.status = :status')
                ->andWhere('q.dateDeleted IS NULL')
                ->setParameters([
                    'status' => 'A',
                ])
                ->orderBy('q.id', 'ASC')
                ->addOrderBy('q.email', 'ASC')
                ->getQuery()
                ->getResult()
        );
    }

    /**
     * Pobranie obdiorców, którzy wyrazili zgodę, a jeszcze nie otrzymali
     * wiadomości. Jeśli jest przekazany limit to maksymalnie tylu odbiorców
     * ma pobrać, jeśli ustawiono pobieranie losowe to zostaną zwróceni
     * losowi odbiorcy.
     *
     * @param Campaign $campaign
     * @param array $groups
     * @param int|bool $limit
     * @param bool $random
     * @return array
     */
    public function findRecipientsConsentedAndWasNoMessageSent(Campaign $campaign, $groups, $limit = false, $random = false)
    {
        if (empty($groups)) {
            return [];
        }

        $groups = implode(',', $groups);
        $em = $this->_em;
        $recipients_table_name = $em->getClassMetadata('WiAdminNewsLetterBundle:Recipients')->getTableName();
        $logs_table_name = $em->getClassMetadata('WiAdminNewsLetterBundle:Logs')->getTableName();

        $rsm = new ResultSetMapping();
        $rsm
            ->addEntityResult(Recipients::class, 'r')
            ->addFieldResult('r', 'id', 'id')
            ->addFieldResult('r', 'email', 'email')
            ->addFieldResult('r', 'name', 'name')
            ->addFieldResult('r', 'consent', 'consent')
            ->addFieldResult('r', 'date_created', 'dateCreated')
            ->addFieldResult('r', 'date_deleted', 'dateDeleted')
            ->addFieldResult('r', 'status', 'status')
        ;

        $sql = "
            SELECT r.id, r.email, r.name, r.consent, r.date_created, r.date_deleted, r.status FROM $recipients_table_name r
            LEFT JOIN $logs_table_name l ON r.id = l.recipient_id
            WHERE r.consent = 1
                AND r.recipientGroup_id IN ($groups)
                AND (l.status IN ('A', 'E') OR l.recipient_id IS NULL)
                AND r.date_deleted IS NULL
                AND (
                    SELECT COUNT(l2.id)
                    FROM $logs_table_name l2
                    WHERE l2.recipient_id = r.id
                        AND l2.status = 'A'
                        AND l2.campaign_id = ".$campaign->getId()."
                ) < 1
            GROUP BY r.email
        ";

        if ($random) {
            $sql .= " ORDER BY RAND()";
        }

        if ($limit) {
            $sql .= " LIMIT ". intval($limit);
        }

        $query = $em->createNativeQuery($sql, $rsm);

        return $query->getResult();
    }

    public function getFindAllByGroupQuery(RecipientGroup $recipientGroup)
    {
        return $this->createQueryBuilder('r')
            ->where('r.recipientGroup = :recipientGroup')
            ->setParameters([
                'recipientGroup' => $recipientGroup,
            ])
            ->getQuery()
        ;
    }

    /**
     * Pobiera odbiorcę na podstawie adresu e-mail z grupy "Zarejestrowani użytkownicy".
     *
     * @param string $email
     * @return Recipient|null
     */
    public function findOneByEmailInRegisterUsersGroup(string $email)
    {
        return $this->createQueryBuilder('r')
            ->innerJoin('r.recipientGroup', 'rg')
            ->where('rg.id = :recipientGroup_id')
            ->andWhere('r.email = :email')
            ->setParameters([
                'recipientGroup_id' => 1,
                'email' => $email,
            ])
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
