<?php

namespace Wi\Admin\NewsLetterBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * ViewNewsletterStatsPerDay Repository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class ViewNewsletterStatsPerDayRepository extends EntityRepository
{
    /**
     * Pobranie wszystkich danych z danego miesiąca.
     *
     * @param string $month
     * @return array
     */
    public function findByMonth($campaign_id, $month)
    {
        return $this->createQueryBuilder('v')
            ->where("v.date LIKE '$month-%'")
            ->andWhere("v.campaignId = $campaign_id")
            ->getQuery()
            ->getResult()
        ;
    }

    public function findBetweenDates($dateStart, $dateEnd)
    {
        return $this->createQueryBuilder('v')
            ->where("v.date BETWEEN :dateStart AND :dateEnd")
            ->setParameters([
                'dateStart' => $dateStart->format('Y-m-d'),
                'dateEnd' => $dateEnd->format('Y-m-d'),
            ])
            ->getQuery()
            ->getResult()
        ;
    }
}
