<div class="large-6 columns">
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="dropdown-recipient-groups">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-recipient-groups" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_new', ['cid'=>$campaign->getId()]); ?>">
                                        <span><i class="icon-folder-add"></i>Create new recipient group</span>
                                    </a>
                                </li>
                                <li>
                                    <a data-open="addGroupModal">
                                        <span><i class="icon-folder-add"></i>Add/Remove recipient groups</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <span>
                        <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                    </span>
                </div>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-folder-open-empty"></i>
                <span>Recipient Groups</span>
            </h3>
        </div>
        <div class="box-body " style="display: none;">
            <table id="campaignInfo" class="table-config tableResp" style="width:100%">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Name</th>
                        <th>Recipients</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($campaign->getRecipientGroups() as $recipientGroup): ?>
                    <tr>
                        <td><?php echo $recipientGroup->getId(); ?></td>
                        <td>
                            <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_show', ['id' => $recipientGroup->getId()]); ?>">
                                <?php echo $recipientGroup->getName(); ?>
                            </a>
                        </td>
                        <td><?php echo $recipientGroup->getRecipientsCount(); ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modals -->
<div class="reveal" id="addGroupModal" data-reveal>
    <div class="add-sender">
        <?php echo $view['form']->start($addGroupForm); ?>
            <div class="add-sender-input">
                <?php echo $view['form']->widget($addGroupForm['recipientGroups']); ?>
            </div>
            <div class="add-sender-button">
                <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                    <i class="icon-edit"></i> Save
                </button>
            </div>
        <?php echo $view['form']->end($addGroupForm); ?>
    </div>
    <button class="close-button" data-close aria-label="Close modal" type="button">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
