<?php $openNotActive = ! is_null($view['request']->getParameter('page')); ?>
<div class="row">
    <!-- Ustawienia -->
    <?php echo $view->render('WiAdminNewsLetterBundle:Newsletter:Components/config.html.php', [
        'config' => $config,
    ]); ?>
    <!-- Statystyki -->
    <?php echo $view->render('WiAdminNewsLetterBundle:Newsletter:Components/statistics.html.php'); ?>
</div>

<!-- Aktywne kampanie -->
<div class="row">
    <div class="large-12 columns">
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="dropdown-1">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-1" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                        <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('newsletter.blockContent.campaign.newCampaign'); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span>Actvive campaigns</span>
                </h3>
            </div>
            <div class="box-body" style="display: block;">
                <div class="row">
                    <table>
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th>Email counter</th>
                                <th>Messages</th>
                                <th>Date expired</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($activeCampaigns as $activeCampaign): ?>
                            <tr>
                                <td><?php echo $activeCampaign->getId(); ?></td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_index', ['id' => $activeCampaign->getId()]); ?>">
                                        <?php echo $activeCampaign->getName(); ?>
                                    </a>
                                </td>
                                <td><?php echo $activeCampaign->getSendMessagesCount(); ?></td>
                                <td><?php echo $activeCampaign->getMessagesCount(); ?></td>
                                <td>
                                    <?php if (! is_null($dateExpired = $activeCampaign->getDateExpired())): ?>
                                        <?php echo $dateExpired->format('Y-m-d'); ?>
                                    <?php endif ?>
                                </td>
                            </tr>
                        <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Nieaktywne kampanie -->
<div class="row">
    <div class="large-12 columns">
        <div class="box<?php echo (! $openNotActive) ? ' collapsed-box' : null; ?>">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="dropdown-2">
                        <i class="icon-cog-5"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-2" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                        <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('newsletter.blockContent.campaign.newCampaign'); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span>Inactvive campaigns</span>
                </h3>
            </div>
            <div class="box-body" style="<?php echo (! $openNotActive) ? 'display: none;' : 'display: block;'; ?>">
                <div class="row">
                    <table>
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th>Email counter</th>
                                <th>Messages</th>
                                <th>Date expired</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($notActiveCampaigns as $notActiveCampaign): ?>
                            <tr>
                                <td><?php echo $notActiveCampaign->getId(); ?></td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_campaign_index', ['id' => $notActiveCampaign->getId()]); ?>">
                                        <?php echo $notActiveCampaign->getName(); ?>
                                    </a>
                                </td>
                                <td><?php echo $notActiveCampaign->getSendMessagesCount(); ?></td>
                                <td><?php echo $notActiveCampaign->getMessagesCount(); ?></td>
                                <td>
                                    <?php if (! is_null($dateExpired = $notActiveCampaign->getDateExpired())): ?>
                                        <?php echo $dateExpired->format('Y-m-d'); ?>
                                    <?php endif ?>
                                </td>
                            </tr>
                        <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
                <div class="row">
                    <div class="medium-12 columns paginationBox">
                        <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                            'knp_pagination' => $notActiveCampaigns,
                        ]); ?>

                        <?php echo $view['knp_pagination']->render($notActiveCampaigns); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
